package com.digiwin.athena.kmservice.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;

/**
 * Gson简单的工具类
 * 可以根据自己需要自行扩展
 * @author yinhaiye
 * @data 2024-07-08
 */
@Slf4j
public class GsonUtils {

    private static final Gson gson = new Gson();

    private GsonUtils() {
    }

    /**
     * 将Java对象转换为JSON字符串
     *
     * @param obj Java对象
     * @return JSON字符串
     */
    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * 将JSON字符串转换为Java对象
     *
     * @param jsonString JSON字符串
     * @param clazz 目标类的Class对象
     * @return 转换后的Java对象
     */
    public static <T> T fromJson(String jsonString, Class<T> clazz) {
        return gson.fromJson(jsonString, clazz);
    }

    /**
     * 将JSON字符串转换为指定类型的集合
     *
     * @param jsonString JSON字符串
     * @param typeToken TypeToken对象，用于获取泛型的实际类型
     * @return 转换后的集合
     */
    public static <T> T fromJson(String jsonString, TypeToken<T> typeToken) {
        return gson.fromJson(jsonString, typeToken.getType());
    }
}
