package com.digiwin.athena.kmservice.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.povo.DapResponse;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;

@Component
@Slf4j
public class KmHttpUtil {
	private static Logger logger = LoggerFactory.getLogger(KmHttpUtil.class);
	private static final String utf8 = "utf8";
	
	public static final String dateformat1="yyyy-MM-dd HH:mm:ss";

	public static final String base64ImgPrefix="data:image/png;base64,";
	
	public static final BigDecimal yuanUnit = new BigDecimal(100);
	
	private static final String base64Key="VHVvMTIzNDU2WXU3ODlMaUJhaVRpYW4=";//base64(Tuo123456Yu789LiBaiTian)
	
	private static AntPathMatcher antMatcher = new AntPathMatcher();
	
	public static HttpClient httpclient = null;
	
	public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000)
			.setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();


	@Autowired(required = false)
	@Qualifier(HttpRouteUtils.ATTEMPT_HTTPCLIENT_ROUTE_PLAN)
	HttpRoutePlanner initHttpRoutePlanner;

	static HttpRoutePlanner httpRoutePlanner;

	@PostConstruct
	public void init() {
		httpRoutePlanner = initHttpRoutePlanner;
	}



	public static DapResponse request(String url, String httpMethod, Map<String,Object> params){
		DapResponse result = new DapResponse();
		String json = requestString(url,httpMethod,params);
		if(null!=json){
			result = JSON.parseObject(json,DapResponse.class);
		}
		return result;
	}


	public static String requestString(String url, String httpMethod, Map<String,Object> params){
		return requestString(url, httpMethod, params, null);
	}

	public static String requestString(String url, String httpMethod, Map<String,Object> params, Map<String,String> headers){
		String result = null;
		if(headers == null){
			headers = new HashMap<>();
		}
		try {
			try {
				URL u = new URL(url);
				String kghost = u.getHost();
				headers.put("Host",kghost);
			} catch (MalformedURLException e) {
				log.error(e.getMessage(), e);
			}

			HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			String routerKey = request.getHeader("routerKey");
			String token = request.getHeader("token");
			String locale = request.getHeader("locale");
			if(null==token){
				token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
				routerKey = (String) DWServiceContext.getContext().getRequestHeader().get("routerKey");
				locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
			}
			if(null==token){
				token = DWServiceContext.getContext().getToken();
			}
			if (null!=routerKey) {
				headers.put("routerKey", routerKey);
			}
			if(null!=token){
				headers.put("token", token);
				headers.put("digi-middleware-auth-user", token);
			}
			if(null!=locale){
				headers.put("locale", locale);
			}
			if("post".equalsIgnoreCase(httpMethod)){
				log.info("Utils requestString beginning... 入参：{}，{}，{}", url, headers, params);
				result= postJson(url,headers,params);
				log.info("Utils requestString ending... 结果：{}", result);

			}else{
				result= get(url,headers,params);
			}
		}catch (Exception e){
			//安静的吃掉异常
			logger.error("request to {} failed,"+e.getMessage(),url);
		}
		return result;
	}

	public static HttpClient getHttpClient() {
		if (null == httpclient) {
			SSLContext sslContext = null;
			try {
				sslContext = SSLContext.getInstance("TLS");
				X509TrustManager tm = new X509TrustManager() {
					@Override
					public void checkClientTrusted(X509Certificate[] chain, String authType)
							throws CertificateException {
					}

					@Override
					public void checkServerTrusted(X509Certificate[] chain, String authType)
							throws CertificateException {
					}

					@Override
					public X509Certificate[] getAcceptedIssuers() {
						return null;
					}
				};

				sslContext.init(null, new TrustManager[] { tm }, null);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				log.error(e.getMessage(), e);
			}

			httpclient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext).setRoutePlanner(httpRoutePlanner)
					// .disableAutomaticRetries()
					.build();
		}
		return httpclient;
	}


	public static HttpClient buildHttpClient() {

			SSLContext sslContext = null;
			try {
				sslContext = SSLContext.getInstance("TLS");
				X509TrustManager tm = new X509TrustManager() {
					@Override
					public void checkClientTrusted(X509Certificate[] chain, String authType)
							throws CertificateException {
					}

					@Override
					public void checkServerTrusted(X509Certificate[] chain, String authType)
							throws CertificateException {
					}

					@Override
					public X509Certificate[] getAcceptedIssuers() {
						return null;
					}
				};

				sslContext.init(null, new TrustManager[] { tm }, null);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				log.error(e.getMessage(), e);
			}

			HttpClient client = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext)
					// .disableAutomaticRetries()
					.build();
			return client;
	}



	public static String getUrl(String url, Map<String, Object> params) {
		String result = url;

		if (null != params && !params.isEmpty()) {
			StringBuilder sb = new StringBuilder();
			sb.append("?");
			params.forEach((k, v) -> {
				try {
					sb.append(k).append("=").append(URLEncoder.encode(v.toString(), "UTF-8")).append("&");
				} catch (UnsupportedEncodingException e) {
					logger.error(e.getMessage(), e);
				}
			});
			result = url + sb.substring(0, sb.length() - 1).toString();
		}

		return result;
	}

	private static Header[] toHeader(Map<String,String> headers){


		if(null!=headers){
			ArrayList<Header> hs = new ArrayList<>();
			headers.forEach((k,v)->{
				hs.add(new BasicHeader(k,v));
			});
			return hs.toArray(new Header[]{});
		}

		return null;
	}

	public static String get(String url, Map<String,String> headers, Map<String, Object> params) {
		String result = null;

		HttpResponse response = get0(url,toHeader(headers),params);
		HttpEntity entity = response.getEntity();
		try {
			result = EntityUtils.toString(entity, "UTF-8");
			if (logger.isInfoEnabled()) {
				logger.info("get result=" + result);
			}
		} catch (IOException e) {
			log.error(e.getMessage(), e);
		}
		HttpClientUtils.closeQuietly(response);

		return result;
	}


	public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {

		if (null != params && !params.isEmpty()) {
			StringBuilder sb = new StringBuilder();
			sb.append("?");
			params.forEach((k, v) -> {
				try {
					String sv = v.toString();
					sb.append(k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
				} catch (UnsupportedEncodingException e) {
					logger.error(e.getMessage(), e);
				}
			});
			url = url + sb.substring(0, sb.length() - 1).toString();
		}
		HttpGet get = new HttpGet(url);
		get.setHeaders(headers);
		HttpResponse response = null;
		if (logger.isInfoEnabled()) {
			logger.info("get url=" + url + ",headers=" + JSON.toJSONString(headers) + ",params=" + params);
		}
		try {
			response = getHttpClient().execute(get);
			return response;
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
		return null;
	}

	public static <T> T get(String url,Map<String,String> headers, Map<String, Object> params, Class<T> c) {
		T result = null;
		try {
			result = JSON.parseObject(get(url, headers, params), c);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		return result;
	}


	public static String postJson(String url, Map<String,String> headers,Map<String,Object> params) {
		String result = null;

		HttpPost httppost = new HttpPost(url);
		httppost.setConfig(requestConfig);
		httppost.setHeaders(toHeader(headers));
		String jsonbody = JSON.toJSONString(params);
		StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
		httppost.setEntity(myEntity);
		HttpResponse response = null;
		if (logger.isInfoEnabled()) {
			logger.info("post to:" + url + ",and request body=" + jsonbody +" and header="+headers);
		}
		try {
			response = getHttpClient().execute(httppost);
			HttpEntity entity = response.getEntity();
			result = EntityUtils.toString(entity, "UTF-8");
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
		} finally {
			HttpClientUtils.closeQuietly(response);
		}
		if (logger.isInfoEnabled()) {
			logger.info("response from :" + url + ",response body=" + result);
		}

		return result;
	}
	
	public static <T> T postJson(String url,Map<String,String> headers, Map<String,Object> params, Class<T> c) {
		T result = null;
		try {
			result = JSON.parseObject(postJson(url, headers, params), c);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		return result;
	}
	
	public static HttpResponse postForm0(String url, Header[] headers, Map<String, Object> params) {


		HttpPost httppost = new HttpPost(url);
		httppost.setConfig(requestConfig);
		httppost.setHeaders(headers);

		HttpResponse response = null;
		if (logger.isInfoEnabled()) {
			logger.info("post to:" + url + ",and request body=" + params);
		}

		List<NameValuePair> nvps = new ArrayList<NameValuePair>();
		for (Iterator iter = params.keySet().iterator(); iter.hasNext();) {
			String name = (String) iter.next();
			String value = String.valueOf(params.get(name));
			nvps.add(new BasicNameValuePair(name, value));
		}
		try {
			httppost.setEntity(new UrlEncodedFormEntity(nvps, utf8));
			response = getHttpClient().execute(httppost);
			
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
		}
		if (logger.isInfoEnabled()) {
			logger.info("response from :" + url + ",response =" + response);
		}

		return response;
	}

	public static String postForm(String url, Header[] headers, Map<String, Object> params) {
		String result = null;

		HttpResponse response = postForm0(url,headers,params);
		if(null==response) {return null;}
		try {					
			HttpEntity entity = response.getEntity();
			result = EntityUtils.toString(entity, "UTF-8");
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
		}finally {
			HttpClientUtils.closeQuietly(response);
		}
		if (logger.isInfoEnabled()) {
			logger.info("response from :" + url + ",response body=" + result);
		}

		return result;
	}
	















	public static Header[] requiredHeaders() {
		Map<String, String> headers = new HashMap<>();
		HttpServletRequest request =
				((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
		String routerKey = request.getHeader("routerKey");
		String token = request.getHeader("token");
		String locale = request.getHeader("locale");
		if (null == token) {
			token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
			routerKey = (String) DWServiceContext.getContext().getRequestHeader().get("routerKey");
			locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
		}
		if (null == token) {
			token = DWServiceContext.getContext().getToken();
		}
		if (null != routerKey) {
			headers.put("routerKey", routerKey);
		}
		if (null != token) {
			headers.put("token", token);
		}
		if (null != locale) {
			headers.put("locale", locale);
		}
		return toHeader(headers);

	}

	public static void requiredHeaders(HttpHeaders headers) {
		try {
			HttpServletRequest request =
					((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
			String routerKey = request.getHeader("routerKey");
			String token = request.getHeader("token");
			String locale = request.getHeader("locale");
			String securityToken = request.getHeader("security-token");
			if (StringUtils.isEmpty(token)) {
				token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
				routerKey = (String) DWServiceContext.getContext().getRequestHeader().get("routerKey");
				locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
			}
			if (StringUtils.isEmpty(token)) {
				token = DWServiceContext.getContext().getToken();
			}
			if (StringUtils.isEmpty(securityToken)) {
				securityToken = (String) DWServiceContext.getContext().getRequestHeader().get("security-token");
			}
			if (!StringUtils.isEmpty(routerKey)) {
				headers.set("routerKey", routerKey);
			}
			if (!StringUtils.isEmpty(token)) {
				headers.set("token", token);
				headers.set(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, token);
			}
			if (!StringUtils.isEmpty(locale)) {
				headers.set("locale", locale);
			}
			if(!StringUtils.isEmpty(securityToken)){
				headers.set("security-token", securityToken);
			}
		} catch (Exception e) {
			log.error("requiredHeaders error,{}", e.toString());
		}
	}


	public static Long getTimeById(String id) {
		ObjectId objectId = new ObjectId(id);
		// 获取时间戳
		return objectId.getDate().getTime();
	}

	public static void main(String[] args) throws IllegalAccessException {


//		Header[] headers = new Header[]{new BasicHeader("token","8bac39b1-1ff2-4085-96b9-9bd577af195a")};
//
//		String str = Utils.get("https://thememap-paas.apps.digiwincloud.com.cn/restful/service/knowledgegraph/task/activityDefinition?activityId=baseDataEntry2&pageCode=basic-data",headers,new HashMap<>());
//
//		System.out.println(str);


		HttpResponse response = get0("http://localhost:8081/user/test/test01",null,null);
		String response2 = get("http://localhost:8081/user/test/test01",null,null);
		System.out.println(response);
		System.out.println(response2);

	}

}
