package com.digiwin.athena.kmservice.action.execution;

import cn.hutool.extra.spring.SpringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class ESPConfiguration {

    private static ESPConfiguration instance;

    @Value("${espUrl:null}")
    private  String espUrl;
    @Value("${mdcUrl:null}")
    private String mdcUrl;

    private static ESPConfiguration getInstance() {
        if (ESPConfiguration.instance == null) {
            ESPConfiguration.instance = SpringUtil.getBean(ESPConfiguration.class);
        }
        return ESPConfiguration.instance;
    }

    public static String getEspUrl() {
        return ESPConfiguration.getInstance().espUrl;
    }


    public static String getMdcUrl() {
        return ESPConfiguration.getInstance().mdcUrl;
    }

}
