package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.AthenaActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class AthenaActionHandlerImpl implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new AthenaActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        AthenaActionExecutionDTO executionDTO = new AthenaActionExecutionDTO();
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setForEach(false);
        executionDTO.setType(ActionTypeEnum.ATHENA);
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_ATHENA_ACTION;
    }
}
