package com.digiwin.athena.kmservice.service;

import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.client.MongoClient;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;

@Slf4j
@Data
public abstract class KmDBService implements InitializingBean {

    private MongoTemplate mongoTemplateSys;

    private MongoTemplate mongoTemplateTenant;

    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier("mappingMongoConverterSystem")
    MappingMongoConverter mappingMongoConverterSystem;

    public abstract MongoTemplate systemTemplate();

    public abstract MongoTemplate tenantTemplate();

    @Override
    public void afterPropertiesSet() {
        SimpleMongoClientDatabaseFactory mongoDbFactorySys = new SimpleMongoClientDatabaseFactory (mongo, KnowledgeGraphDb.SYSTEM.getValue());
        mongoTemplateSys = new MongoTemplate(mongoDbFactorySys, mappingMongoConverterSystem);
        SimpleMongoClientDatabaseFactory  mongoDbFactoryTenant = new SimpleMongoClientDatabaseFactory (mongo, KnowledgeGraphDb.TENANT.getValue());
        mongoTemplateTenant = new MongoTemplate(mongoDbFactoryTenant, mappingMongoConverterSystem);
    }
}
