package com.digiwin.athena.kmservice.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

@ConditionalOnProperty(name = "mock.service",havingValue = "true")
@Service
public class MockDataPickService extends DataPickService {


    @Autowired
    protected MongoTemplate mongoTemplate;;
    @Autowired(required = false)
    @Qualifier("mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;

    @Override
    public MongoTemplate systemTemplate() {
        return mongoTemplate;
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return mongoTemplateTenant;
    }

    @Override
    public String tenantVersion(String tenantId) {
        return "1.0";
    }

    @Override
    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        return null;
    }

    @Override
    public boolean isTenantCol(Class c) {
        return false;
    }

    @Override
    public boolean isSystemCol(Class c) {
        return false;
    }
}
