package com.digiwin.athena.kmservice.utils;

import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.FieldDataPrecision;
import com.digiwin.athena.dto.ProdType;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.dto.MultiLanguageDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

/**
 * @title: MetadataTranslator
 * @projectName: kg
 * @description: MetadataTranslator
 * @author: linc
 * @date 2023/8/1 17:27
 * @version: 1.0
 */
@Slf4j
public class MetadataTranslator {

    public static final String DESCRIPTION_FILED = "Description";
    public static final String REMARK_FILED = "Remark";

    public static void translateField(GetActionLocaleResponseDTO localeResponseDTO, ActionMetadataDTO responseDTO, String localeStr, ProductNameGetter productNameGetter) {
        List<ApiDataFieldLocaleMetadataDTO> reqApiDataFieldLocaleMetadataDTOS = localeResponseDTO.getRequest().getParameters();
        String getLang = "get" + localeStr.substring(0, 1).toUpperCase() + localeStr.substring(1);
//        if (getLang.equals("getEn_US")) {
//            getLang = "getEn";
//        }
        if (null != reqApiDataFieldLocaleMetadataDTOS) {
            for (int i = 0; i < reqApiDataFieldLocaleMetadataDTOS.size(); i++) {
                ApiDataFieldMetadataDTO requestParams = responseDTO.getRequest().getParameters().get(i);
                reqApiDataFieldLocaleMetadataDTOS.get(i).setDescription(getTargetLang(getLang, requestParams, requestParams.getClass(), DESCRIPTION_FILED));
                reqApiDataFieldLocaleMetadataDTOS.get(i).setRemark(getTargetLang(getLang, requestParams, requestParams.getClass(), REMARK_FILED));
                List<ApiDataFieldLocaleMetadataDTO> field = reqApiDataFieldLocaleMetadataDTOS.get(i).getField();
                if ("object".equals(reqApiDataFieldLocaleMetadataDTOS.get(i).getData_type())) {
                    translateRecursively(field, requestParams.getField(), getLang, productNameGetter);
                } else if (productNameGetter != null) {
                    //有产品名称，并且不是object类型，则查找对应产品字段精度
                    reqApiDataFieldLocaleMetadataDTOS.get(i).setPrecision(getFieldPrecisionByProductName(requestParams, productNameGetter));
                }
            }
        }
        //resApiDataFieldMetadata多语言重新赋值
        ApiDataFieldLocaleMetadataDTO resApiDataFieldLocaleMetadataDTO = localeResponseDTO.getResponse().getData();
        ApiDataFieldMetadataDTO resFieldMetadata = responseDTO.getResponse().getData();
        if (resApiDataFieldLocaleMetadataDTO != null) {
            resApiDataFieldLocaleMetadataDTO.setDescription(getTargetLang(getLang, resFieldMetadata, resFieldMetadata.getClass(), DESCRIPTION_FILED));
            resApiDataFieldLocaleMetadataDTO.setRemark(getTargetLang(getLang, resFieldMetadata, resFieldMetadata.getClass(), REMARK_FILED));

            List<ApiDataFieldLocaleMetadataDTO> responseField = resApiDataFieldLocaleMetadataDTO.getField();
            if (!CollectionUtils.isEmpty(responseField)) {
                for (int j = 0; j < responseField.size(); j++) {
                    responseField.get(j).setDescription(getTargetLang(getLang, resFieldMetadata.getField().get(j), resFieldMetadata.getField().get(j).getClass(), DESCRIPTION_FILED));
                    responseField.get(j).setRemark(getTargetLang(getLang, resFieldMetadata.getField().get(j), resFieldMetadata.getField().get(j).getClass(), REMARK_FILED));
                    if ("object".equals(responseField.get(j).getData_type())) {
                        translateRecursively(responseField, resFieldMetadata.getField(), getLang, productNameGetter);
                    } else if (productNameGetter != null) {
                        //有产品名称，并且不是object类型，则查找对应产品字段精度
                        responseField.get(j).setPrecision(getFieldPrecisionByProductName(resFieldMetadata.getField().get(j), productNameGetter));
                    }
                }
            } else if (productNameGetter != null) {
                //有产品名称，并且不是object类型，则查找对应产品字段精度
                resApiDataFieldLocaleMetadataDTO.setPrecision(getFieldPrecisionByProductName(resFieldMetadata, productNameGetter));
            }
        }
    }

    public static void translateRecursively(List<ApiDataFieldLocaleMetadataDTO> target, List<ApiDataFieldMetadataDTO> source, String getLang, ProductNameGetter productNameGetter) {
        if(null==target || null==source){return;}
        for (int i = 0; i < target.size(); i++) {
            target.get(i).setDescription(getTargetLang(getLang, source.get(i), source.get(i).getClass(), DESCRIPTION_FILED));
            target.get(i).setRemark(getTargetLang(getLang, source.get(i), source.get(i).getClass(), REMARK_FILED));
            if ("object".equals(target.get(i).getData_type())) {
                translateRecursively(target.get(i).getField(), source.get(i).getField(), getLang, productNameGetter);
            } else if (productNameGetter != null) {
                //有产品名称，并且不是object类型，则查找对应产品字段精度
                target.get(i).setPrecision(getFieldPrecisionByProductName(source.get(i), productNameGetter));
            }
        }
    }

    public static String getFieldPrecisionByProductName(ApiDataFieldMetadataDTO source, ProductNameGetter productNameGetter) {
        FieldDataPrecision data_precision = source.getData_precision();
        List<ProdType> prodTypeList = null;
        if (data_precision != null && !CollectionUtils.isEmpty(prodTypeList = data_precision.getProd_type())) {
            if (null == productNameGetter) {
                return null;
            }
            String productName = productNameGetter.getProductName();
            if (StringUtils.isBlank(productName)) {
                return null;
            }
            Optional<ProdType> result = prodTypeList.stream().filter(e -> productName.equals(e.getProd_name())).findAny();
            if (result.isPresent()) {
                return result.get().getPrecision();
            }
        }
        return null;
    }

    private static String getTargetLang(String getLang, Object langTarget, Class langTargetClazz, String fieldCamel) {
        if (langTarget == null) {
            return "";
        }
        String getMethodStr = "get" + fieldCamel;
        try {
            Method langMethod = MultiLanguageDTO.class.getMethod(getLang);
            Method targetMethod = langTargetClazz.getMethod(getMethodStr);
            MultiLanguageDTO languageDTO = (MultiLanguageDTO) targetMethod.invoke(langTarget);
            if (languageDTO == null) {
                return "";
            }
            String result = (String) langMethod.invoke(languageDTO);
            // 此处是为了兼容部分EspAction中英文语言字符为“en_US”
            if(ObjectUtils.isEmpty(result) && "getEn".equals(getLang)){
                return getTargetEnUSLang(langTarget, targetMethod);
            }
            return result;
        } catch (Exception e) {
            log.warn("error parse locale:{}", e.getMessage());
        }
        return "";
    }

    /**
     * 获取英文文案
     * @param langTarget
     * @param targetMethod
     * @return
     */
    private static String getTargetEnUSLang(Object langTarget, Method targetMethod){
        try {
            Method langMethod = MultiLanguageDTO.class.getMethod("getEn_US");
            MultiLanguageDTO languageDTO = (MultiLanguageDTO) targetMethod.invoke(langTarget);
            if (languageDTO == null) {
                return "";
            }
            String result = (String) langMethod.invoke(languageDTO);
            return result;
        } catch (Exception e) {
            log.warn("error parse locale:{}", e);
        }
        return "";
    }

}
