package com.digiwin.athena.kmservice.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.expression.ExpressionUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.support.DapContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;


@Slf4j
public class ServiceUtils {


    private static ThreadLocal<DapContext> profileContext = new InheritableThreadLocal<>();
    private static ThreadLocal<String> eocHolder = new ThreadLocal<>();
    public static DapContext getContext(){
        DapContext context = profileContext.get();
        if(null==context){
            context = new DapContext();
            Map<String,Object> profile = DWServiceContext.getContext().getProfile();
            Map<String,Object>  header =DWServiceContext.getContext().getRequestHeader();
            if(null!=profile){context.setProfiles(profile);}
            if(null!=header){
                context.setHeaders(header);
                String eoc = (String) header.get("athena-eoc");
            }
            setContext(context);
        } else {
            Map<String, Object> profiles = context.getProfiles();
            // 匿名接口调用可能没有profile，如果需要租户信息，需要在接口中添加tenantId参数，因此需要重新设置值
            if (ObjectUtil.isEmpty(profiles)) {
                Map<String,Object> profile = DWServiceContext.getContext().getProfile();
                if(null!=profile){
                    context.setProfiles(profile);
                    setContext(context);
                }
            }
        }
        return context;
    }

    public static void setContext(DapContext context){
        profileContext.set(context);
    }

    public static String getLocale(){
        return (String) getContext().getHeaders().get("locale");
    }

    public static String getToken(){
        String token = (String) getContext().getHeaders().get("token");
        if(null==token){
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            token = request.getHeader("token");
        }
        return token;
    }

    public static String getSecurityToken(){
        String token = (String) getContext().getHeaders().get("security-token");
        if(null==token){
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            token = request.getHeader("security-token");
        }
        return token;
    }

    public static void setLocale(String locale){
        if(StringUtils.isEmpty(locale)){return;}
        getContext().getHeaders().put("locale",locale);
    }

    public static String getTenantIdSilent(){
        return (String) getContext().getProfiles().get("tenantId");
    }

    public static void setTenantId(String tenantId){
        getContext().getProfiles().put("tenantId",tenantId);
    }

    public static String getTenantId() throws DWBusinessException {
        String tenantId = getTenantIdSilent();
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("datamap.tokenMissingTenantId"));
        }
        return tenantId;
    }

    public static String getUserId()  throws DWBusinessException{
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if(profile != null){
            return (String) profile.getOrDefault("userId", null);
        }else{
            throw new DWBusinessException("not found userId from token");
        }

    }

    /*
    ctx包含属性 token,security-token,tenantId,userId,locale
    {tenantName=pass区测试租户(E10_6.0), tenantSid=380745286255168, tenantId=E10ATHENApass, userSid=381050902839872, userName=业务员1, userId=E10PASS14}
     */
    public static Object evalExpressionWithContext(String expression, Map<String,Object> data)  {
        Map<String,Object> root = new HashMap<>();
        Map<String,Object> ctx = getContext().contextInfo();
        root.put("ctx",ctx);
        if(null!=data){
            root.putAll(data);
        }
        return evalExpression(expression,root);
    }

    public static Object evalExpression(String expression, Map<String,Object> data)  {
        Object obj = ExpressionUtil.eval(expression,data);
        return obj;
    }


    public static <K, V> boolean compareMaps(Map<K, V> map1, Map<K, V> map2) {
        if(ObjectUtil.equals(map1,map2)){
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (!map2.containsKey(key) || !ObjectUtil.equals(map2.get(key),value)) {
                return false;
            }
        }
        return true;
    }


    public static Method getSetMethod(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            //  System.out.println(method +"==="+objectClass.getSuperclass());
            return method;
        }catch (NoSuchFieldException e0){
            if(objectClass.getSuperclass()!=null && !objectClass.getSuperclass().equals(Object.class)) {
                return getSetMethod(objectClass.getSuperclass(), fieldName);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return null;
    }

    public static java.util.List<Field> getFields(Class<?> clazz){

        Class<?> c = clazz;
        java.util.List<Field> fields = new ArrayList<>();

        do {
            Field[] fs = c.getDeclaredFields();
            for(Field f:fs ) {
                int mod = f.getModifiers();
                if(!Modifier.isStatic(mod) && !Modifier.isFinal(mod) && !isContain(fields,f)) {
                    fields.add(f);
                }
            }
            c = c.getSuperclass();
        } while (c != null);

        return fields;
    }

    public static boolean isContain(List<Field> fieldList, Field field){
        for(Field temp:fieldList){
            if(temp.getName().equals(field.getName())){
                return true;
            }
        } return false; }

    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {
            return c.isPrimitive()
                    || Number.class.isAssignableFrom(c)
                    || Byte.class.equals(c)
                    || Short.class.equals(c)
                    || Integer.class.equals(c)
                    || Long.class.equals(c)
                    || Boolean.class.equals(c)
                    || Float.class.equals(c)
                    || Double.class.equals(c)
                    || Character.class.isAssignableFrom(c)
                    || CharSequence.class.isAssignableFrom(c)
                    || Date.class.isAssignableFrom(c)
                    || LocalDate.class.isAssignableFrom(c)
                    || LocalDateTime.class.isAssignableFrom(c)
                    || Calendar.class.isAssignableFrom(c);

        }
        return false;
    }

    public static Object getHeader(String header){
        return DWServiceContext.getContext().getRequestHeader().get(header);
    }

    public static String getEoc(){
        if(null==eocHolder.get()){
            Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
            if (headers != null && headers.containsKey("athena-eoc")) {
                String eoc = (String) headers.get("athena-eoc");
                if(null!=eoc){
                    eocHolder.set(eoc);
                }
            }
        }
        return  eocHolder.get();
    }
    public static void setEoc(String eoc){
        eocHolder.set(eoc);
    }
    public static boolean isArray(Object v){
        if(v==null){return false;}
        if(v instanceof Collection || v.getClass().isArray() ){
            return true;
        }
        return false;
    }

    public static boolean isMapOrObject(Object v){
        if(v==null){return false;}
        if(v instanceof Collection || v.getClass().isArray() || isPrimitive(v.getClass())){return false;}
        return true;
    }

    public static String getCurrentLocale() {
        String localeString = "zh_CN";
        Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
        if (headers != null && headers.containsKey("locale")) {
            localeString = (String)headers.get("locale");
        }
        return localeString;
    }

    public static <T> T cast(Object obj,Class<T> c){
        T t = null;
        if(obj ==null){return null;}
        if(c.isAssignableFrom(obj.getClass())){
            t = (T) obj;
        }else{
            t = JSON.parseObject(JSON.toJSONString(obj),c);
        }
        return t;
    }

    public static String localeName(Object obj ,String field,String locale){
        String str = null;
        if(obj ==null || null== field){return str;}
        Map lang=null;
        if(obj instanceof Map){
            Map objMap = (Map) obj;
            str = (String) objMap.get(field);
            lang = (Map) objMap.get("lang");
        }else{
            str = (String) ReflectUtil.getFieldValue(obj,field);
            lang = (Map) ReflectUtil.getFieldValue(obj,"lang");
        }

        if(null!=lang && null!=locale){
            Map langField = (Map) lang.get(field);
            if(null!=langField){
                String  str0 = (String) langField.get(locale);
                if(null!=str0){
                    str = str0;
                }
            }
        }

        return str;
    }


    public static void main(String[] args) {
//        Map<String,Object> data = new HashMap<>();
//        data.put("p1","hello");
//        data.put("p2",3);
//        data.put("p3", List.of("aa","bb","cc"));
//        data.put("p4", List.of(MapUtil.of("a","aa"),MapUtil.of("b","bb")));
//        Object obj = evalExpressionWithContext("p1+':'+p4",data);
//        System.out.println(obj);
    }


}
