/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionConfig;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ESPServiceVO;
import com.digiwin.athena.kg.action.StartDataEventAction;
import com.digiwin.athena.kg.dto.DataEntityDependencyAndMapsDTO;
import com.digiwin.athena.kg.dto.DataFieldAndMapsDTO;
import com.digiwin.athena.kg.dto.DependencyAndMapsDTO;
import com.digiwin.athena.kg.dto.EntityDependencyDTO;
import com.digiwin.athena.kg.dto.SwitchDependencyAndMapsDTO;
import java.util.List;
import java.util.Set;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface ActionRepository
extends Neo4jRepository<Action, Long> {
    @Query(value="match(n:Action {actionId:$0, version: $1}) RETURN n")
    public List<Action> getActionByActionId(String var1, String var2);

    @Query(value="match(a:Action) where a.actionId in $0 return a")
    public List<Action> getActionByActionIds(Set<String> var1);

    public List<Action> findOneByActionId(String var1);

    public List<Action> findByActionId(String var1);

    public List<Action> findByActionIdAndVersion(String var1, String var2);

    @Query(value="MATCH (action:Action) where action.ruleId = $0 return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel")
    public List<ActionLabel> getActionAndLabelsByRuleId(String var1);

    @Query(value="MATCH (action:Action) where action.actionId = $0 return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel")
    public List<ActionLabel> getActionAndLabels(String var1);

    @Query(value="MATCH (action:StartDataEventAction) where action.actionId = $0 return action")
    public List<StartDataEventAction> getDataMapAction(String var1);

    @Query(value="MATCH (action:Action{version:$2}) where  action.actionId = $0 and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel ")
    public List<ActionLabel> getActionAndLabels(String var1, String var2, String var3);

    @Query(value="MATCH(action:Action{version:$2}) where  action.actionId in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel ")
    public List<ActionLabel> getActionAndLabels(List<String> var1, String var2, String var3);

    @Query(value="match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action) where nextAction.actionId = $0  return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    public List<DependencyAndMapsDTO> queryDependencyAndMaps(String var1);

    @Query(value="match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action{tenantId:$1}) where  nextAction.actionId = $0 and nextAction.tenantId = $1 return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    public List<DependencyAndMapsDTO> queryDependencyAndMaps(String var1, String var2, String var3);

    @Query(value="match (nextAction:Action)-[:Requires]->(tde:DataEntity)-[:MapsTo]->(sde:DataEntity)<-[:Creates]-(sourceAction:Action) where nextAction.actionId = $0 return tde.name as targetName,sde.name as sourceName, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    public List<DataEntityDependencyAndMapsDTO> queryDataEntityDependencyAndMaps(String var1);

    @Query(value="match(nextAction:Action{version:$2})-[:Requires]->(tde:DataEntity)-[:MapsTo]->(sde:DataEntity)<-[:Creates]-(sourceAction:Action{tenantId:$1}) where nextAction.actionId = $0 and nextAction.tenantId = $1 return tde.name as targetName,sde.name as sourceName, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    public List<DataEntityDependencyAndMapsDTO> queryDataEntityDependencyAndMaps(String var1, String var2, String var3);

    @Query(value="match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(switchBox:SwitchBox)-[:CaseWhen]->(cv:CaseValue)-[:CaseThen]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action), (switchBox)-[:Pulling]->(boxData:DataField)<-[:Contains*0..3]-()<-[:Creates]-(switchSourceAction:Action) where nextAction.actionId = $0 return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath,sourceAction.actionId as sourceActionId, cv.name as switchName, labels(sourceAction) as sourceActionLabels,boxData.fullPath as boxPullingPath, switchSourceAction.actionId as boxPullingActionId")
    public List<SwitchDependencyAndMapsDTO> querySwitchDependencyAndMaps(String var1);

    @Query(value="match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(switchBox:SwitchBox)-[:CaseWhen]->(cv:CaseValue)-[:CaseThen]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action{tenantId:$1}), (switchBox)-[:Pulling]->(boxData:DataField)<-[:Contains*0..3]-()<-[:Creates]-(switchSourceAction:Action{tenantId:$1}) where  nextAction.actionId = $0 and nextAction.tenantId = $1  return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath,sourceAction.actionId as sourceActionId, cv.name as switchName, labels(sourceAction) as sourceActionLabels,boxData.fullPath as boxPullingPath, switchSourceAction.actionId as boxPullingActionId")
    public List<SwitchDependencyAndMapsDTO> querySwitchDependencyAndMaps(String var1, String var2, String var3);

    @Query(value="match (nextAction:Action)-[:Requires]->(targetEntity:DataEntity)-[:Contains]->(targetField:DataField) where nextAction.actionId = $0 return targetEntity.name as targetEntityName, collect(targetField.fullPath) as targetFieldFullPaths")
    public List<EntityDependencyDTO> queryEntityDependency(String var1);

    @Query(value="match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetEntity:DataEntity)-[:Contains]->(targetField:DataField) where  nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return targetEntity.name as targetEntityName, targetEntity.fullPath as targetEntityFullPath, collect(targetField.fullPath) as targetFieldFullPaths")
    public List<EntityDependencyDTO> queryEntityDependency(String var1, String var2, String var3);

    @Query(value="match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(de:DataEntity) where nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return de.fullPath as targetEntityFullPath")
    public List<String> queryDataEntitys(String var1, String var2);

    @Query(value="match (nextAction:Action)-[:Requires]->(targetField:DataField)-[:MapsTo]->(mapField:DataField) where nextAction.actionId = $0 return targetField.name as targetFieldName, targetField.fullPath as targetFieldFullPath, mapField.name as mapFieldName, mapField.fullPath as mapFieldFullPath, id(mapField) as mapFieldId")
    public List<DataFieldAndMapsDTO> queryDataFieldAndMaps(String var1);

    @Query(value="match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(mapField:DataField) where nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return targetField.name as targetFieldName, targetField.fullPath as targetFieldFullPath, mapField.name as mapFieldName, mapField.fullPath as mapFieldFullPath, id(mapField) as mapFieldId")
    public List<DataFieldAndMapsDTO> queryDataFieldAndMaps(String var1, String var2, String var3);

    @Query(value="match (action:Action)-[:ACTIONCONFIG]->(config:ActionConfig) where action.actionId=$0 return config limit 1")
    public ActionConfig queryActionConfig(String var1);

    @Query(value="match (action:Action)-[:ACTIONCONFIG]->(config:ActionConfig) where action.actionId=$0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return config limit 1")
    public ActionConfig queryActionConfig(String var1, String var2);

    @Query(value="match (action:Action)-[:Requires]->(f:DataField) where id(f)=$0 return action.actionId")
    public List<String> queryActionIdByRequiredField(String var1);

    @Query(value="match (action:Action{version:$2})-[:Requires]->(f:DataField) where  id(f)=$0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action.actionId")
    public List<String> queryActionIdByRequiredField(String var1, String var2, String var3);

    @Query(value="match (action:EspAction{version:$2}) where action.tenantId in ['SYSTEM',$0] or action.tenantId is null return action.serviceName as serviceName, case when $1 = 'zh_CN' then action.actionName else action.actionName_tw end as serviceDesc")
    public List<ESPServiceVO> queryEspService(String var1, String var2, String var3);

    @Query(value="MATCH (action:TaskDataGroupAction) where action.taskId = $0 return action")
    public List<Action> getTaskDataGroupAction(String var1);

    @Query(value="match (m:MonitorRule)-[:Triggers]->(a:Action) where m.code = $0 return a")
    public Action getMonitorTriggerAction(String var1);

    @Query(value="match (m:MonitorRule) where m.code = $0 and m.version = $1 return m.sourceIdKey")
    public String getSourceIdKey(String var1, String var2);

    @Query(value="MATCH (action:Action{version:$1}) where action.actionId in $0 return action")
    public List<Action> getActions(List<String> var1, String var2);

    @Query(value="MATCH(action:Action{version:$2}) where  action.dataFlowCode in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels ")
    public List<ActionLabel> getActionAndLabelsByDataFlowCode(List<String> var1, String var2, String var3);

    @Query(value="MATCH(action:Action{version:$2}) where  action.parentMetricCode in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels ")
    public List<ActionLabel> getActionAndLabelsByMetricId(List<String> var1, String var2, String var3);
}

