package com.digiwin.athena.kmservice.action.execution;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.dto.*;
import com.digiwin.athena.kmservice.action.execution.model.*;
import com.digiwin.athena.kmservice.action.metadata.KmActionClient;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.common.Constants;
import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 定义为原型模式，防止三个map中数据不是本实例数据
 * 在单例bean中调用原型bean，参考com.digiwin.athena.knowledgegraph.action.ActionService#getDataPullingPathGenerator()
 */
@Service
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class KmDataPullingPathGenerator {

    @Autowired(required = false)
    private ActionRepository actionRepository;

    @Autowired
    private KmActionClient actionClient;


    //实体中最大的层次深度，3层代表可以有单头、单身、子单身、子子单身
    private final static int MAX_ENTITY_FIELD_LEVEL = 3;
    private HashMap<String, ActionExecutionDTO> actions = new HashMap<>();
    private HashMap<String, ActionDefinitionDTO> actionMetadatas = new HashMap<>();
    private HashMap<String, Boolean> visitedActionIds = new HashMap<>();
    private String rootAction="";


    @Cache(key = "action:actionExecutionPath$0$1$2$3", namespace = Constants.REDIS_KNOWLEDGE_GRAPH, ttlSecs = 86400L)
    public ActionExecutionPathDTO Generate(String actionId, String tenantId, List<String> existingActionParamNames, String tenantVersion) throws Exception {
        rootAction = actionId;
        TryGenerateAction(actionId, tenantId, existingActionParamNames, tenantVersion);
        ActionExecutionPathDTO pathDTO = new ActionExecutionPathDTO();
        pathDTO.setActions(new ArrayList<>(actions.values()));
        pathDTO.setActionMetadatas(new ArrayList<>(actionMetadatas.values()));
        return pathDTO;
    }

    //目前是深度优先遍历，对于调用方而言，不应该依赖于产生Action的顺序
    //当Action的来源无法找齐时，返回false
    private boolean TryGenerateAction(String actionId, String tenantId, List<String> existingActionParamNames, String tenantVersion) throws Exception {
        //目前一个action在子图中只能出现一次，否则具有二义性。
        //visitedActionIds中记录了之前访问action时，有没有成功地将它加入子图。
        //如果action的依赖不完整，即使访问过也不会被加入子图。
        //这种情况下，如果再次访问到也不必再分析一次，直接返回false即可。
        if (visitedActionIds.containsKey(actionId)) {
            return visitedActionIds.get(actionId);
        }
        //20200916 maxl 在没有分析完前都是给false，分析完才更新为true，避免同一个action被递归到两次，第二次被误认为是分析成功的。
        visitedActionIds.put(actionId, false);

        //先加入当前Action
        String actionTenantId = QueryAndPutCurrentAction(actionId, tenantId, tenantVersion);
        ActionExecutionDTO executionDTO = actions.get(actionId);
        ActionDefinitionDTO metadataDTO = actionMetadatas.get(actionId);
        executionDTO.setParams(new ArrayList<>());

        List<String> processedPullingSourceActionIds = new ArrayList<>();
        List<PullingActionExecutionParamDTO> processedPullingParams = new ArrayList<>();
        LevelMapping levelMapping = new LevelMapping();
        //再查找当前Action的依赖
        List<DependencyAndMapsDTO> queryResults = this.actionRepository.queryDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        //查询dataEntity直接依赖
        List<DataEntityDependencyAndMapsDTO> queryEntityResults = this.actionRepository.queryDataEntityDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        List<String> queryEntitySourceActionIds = queryEntityResults.parallelStream().map(
                item -> item.getSourceActionId()).collect(Collectors.toList());
        int originalPullingParamSize = queryResults.size();
        //用dataEntity过滤已有的dataField依赖,dataEntity包含的则dataField不需要
        queryResults = queryResults.stream().filter(item ->
                !queryEntitySourceActionIds.contains(item.getSourceActionId())).collect(Collectors.toList());
        int filteredPullingParamSize = originalPullingParamSize - queryResults.size();
        //单独查找带有SwitchBox的路径
        List<SwitchDependencyAndMapsDTO> querySwitchResults = this.actionRepository.querySwitchDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        //将switchResult根据targetAction进行分组
        Map<String, List<SwitchDependencyAndMapsDTO>> querySwitchResultGroups = querySwitchResults.stream().collect(Collectors.groupingBy(SwitchDependencyAndMapsDTO::getTargetFieldPath));

        //用以记录已经找到依赖的参数路径 （非pulling）
        Set<String> paramsFoundDependency = new HashSet<>();
        //用以记录pulling找到的
        Set<String> paramsPullingFoundDependency = new HashSet<>();
//        Boolean dataFlag = false;
        for (DependencyAndMapsDTO record : queryResults) {
            if(StringUtils.isEmpty(record.getTargetFieldPath()) || StringUtils.isEmpty(record.getSourceFieldPath())
                || StringUtils.isEmpty(record.getSourceActionId() )|| CollectionUtils.isEmpty(record.getSourceActionLabels())){
                continue;
            }
            String targetFieldPath = record.getTargetFieldPath();
            String sourceFieldPath = record.getSourceFieldPath();
            String sourceActionId = record.getSourceActionId();
            List<String> sourceActionLabels = record.getSourceActionLabels();

            String targetFieldName = targetFieldPath.substring(targetFieldPath.lastIndexOf(".") + 1);
            //如果有参数，优先使用参数
            //第一版使用最简单的参数匹配规则，即参数名一致的情况下，认为可以匹配使用
            if ((existingActionParamNames.contains(targetFieldName) || existingActionParamNames.contains(targetFieldPath))
                    && !paramsFoundDependency.contains(targetFieldPath)) {
                // todo 敏捷报表要修改这里，梳理老逻辑  // 有pulling的MapsTo关系认为type是pulling
                if (StringUtils.isNotEmpty(sourceFieldPath) &&  /*!sourceFieldPath.equals(targetFieldName)
                        &&*/ TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) {
                    paramsFoundDependency.add(targetFieldPath);
//                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    PullingActionExecutionParamDTO paramDTO = new PullingActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PULLING);
                    paramDTO.setValue(Constants.ROOT + sourceFieldPath);
                    paramDTO.setName(Constants.ROOT + targetFieldPath);
                    paramDTO.setSource(sourceActionId);
                    levelMapping.putPulling(sourceActionId,Constants.ROOT + targetFieldPath,Constants.ROOT + sourceFieldPath);
                    executionDTO.getParams().add(paramDTO);
                }else {
                    // todo
                    paramsFoundDependency.add(targetFieldPath);
                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PARAM);
                    paramDTO.setValue(Constants.ROOT + sourceFieldPath);
                    paramDTO.setName(Constants.ROOT + targetFieldPath);
                    if (existingActionParamNames.contains(targetFieldName)) {
                        paramDTO.setValue(Constants.ROOT + targetFieldName);
                    }
                    else {
                        paramDTO.setValue(Constants.ROOT + targetFieldPath);
                    }
//                paramDTO.setValue(Constants.ROOT + targetFieldPath);
                    levelMapping.put(existingActionParamNames, targetFieldPath);
//                    levelMapping.put(existingActionParamNames, targetFieldPath,ActionParamTypeEnum.PULLING.toString());
                    executionDTO.getParams().add(paramDTO);

                    // todo
                    /*PullingActionExecutionParamDTO pullingActionExecutionParamDTO = new PullingActionExecutionParamDTO();
                    pullingActionExecutionParamDTO.setType(ActionParamTypeEnum.PULLING);
                    pullingActionExecutionParamDTO.setValue(Constants.ROOT + sourceFieldPath);
                    pullingActionExecutionParamDTO.setName(Constants.ROOT + targetFieldPath);
                    pullingActionExecutionParamDTO.setSource(sourceActionId);
                    executionDTO.getParams().add(pullingActionExecutionParamDTO);*/
                }

            }
            else {
                if (this.effectiveAction(sourceActionLabels)
                        && !paramsFoundDependency.contains(targetFieldPath)) {
                    //判断如果来源的Action并不能找齐参数，则不能作为参数来源
                    if (TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) {
                        paramsPullingFoundDependency.add(targetFieldPath);
                        PullingActionExecutionParamDTO pullingParamDTO = new PullingActionExecutionParamDTO();
                        pullingParamDTO.setType(ActionParamTypeEnum.PULLING);
                        pullingParamDTO.setSource(sourceActionId);
                        pullingParamDTO.setValue(Constants.ROOT + sourceFieldPath);
                        pullingParamDTO.setName(Constants.ROOT + targetFieldPath);
                        processedPullingParams.add(pullingParamDTO);
                        if (!visitedActionIds.containsKey(actionId)) {
                            processedPullingSourceActionIds.add(sourceActionId);
                        }
                        levelMapping.putPulling(sourceActionId,Constants.ROOT + targetFieldPath,Constants.ROOT + sourceFieldPath);
                        // todo data.data结构引起的问题，$丢失，后续要去掉
                        /*if (targetFieldPath.contains("data.data") && sourceFieldPath.contains("executeActionResult")  && !dataFlag) {
                            PullingActionExecutionParamDTO pullingParamDTOs = new PullingActionExecutionParamDTO();
                            pullingParamDTOs.setName((Constants.ROOT + "data"));
                            pullingParamDTOs.setValue("$");
                            pullingParamDTOs.setType(ActionParamTypeEnum.PULLING);
                            pullingParamDTOs.setSource(sourceActionId);
                            processedPullingParams.add(pullingParamDTOs);
                            dataFlag = true;
                        }*/
                    }
//                    else {
//                        if (!sourceActionId.equals(rootAction)) {
//                            actions.remove(sourceActionId);
//                            actionMetadatas.remove(sourceActionId);
//                        }
//                    }
                }
            }
        }

        for (DataEntityDependencyAndMapsDTO record : queryEntityResults) {
            String targetName = record.getTargetName(); // record.get("targetName").toString();
            String sourceName = record.getSourceName(); // record.get("sourceName").toString();
            String sourceActionId = record.getSourceActionId(); // record.get("sourceActionId").toString();
//            List<String> sourceActionLabels = (List<String>)record.get("sourceActionLabels");
            List<String> sourceActionLabels = record.getSourceActionLabels(); // Arrays.asList ((String[])record.get("sourceActionLabels"));

            //如果有参数，优先使用参数
            //第一版使用最简单的参数匹配规则，即参数名一致的情况下，认为可以匹配使用
            if (existingActionParamNames.contains(targetName) && !paramsFoundDependency.contains(targetName)) {
                paramsFoundDependency.add(targetName);
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(Constants.ROOT + targetName);
                paramDTO.setValue(Constants.ROOT + targetName);
                levelMapping.put(existingActionParamNames, targetName);
//                levelMapping.put(existingActionParamNames, targetName,ActionParamTypeEnum.PARAM.toString());
                executionDTO.getParams().add(paramDTO);
            }
            else {
                if (this.effectiveAction(sourceActionLabels)
                        && !paramsFoundDependency.contains(targetName)) {
                    //判断如果来源的Action并不能找齐参数，则不能作为参数来源
                    if (TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) {
                        paramsPullingFoundDependency.add(targetName);
                        PullingActionExecutionParamDTO pullingParamDTO = new PullingActionExecutionParamDTO();
                        pullingParamDTO.setType(ActionParamTypeEnum.PULLING);
                        pullingParamDTO.setSource(sourceActionId);
                        pullingParamDTO.setValue(Constants.ROOT + sourceName);
                        pullingParamDTO.setName(Constants.ROOT + targetName);
                        processedPullingParams.add(pullingParamDTO);
                        if (!visitedActionIds.containsKey(actionId)) {
                            processedPullingSourceActionIds.add(sourceActionId);
                        }
                        levelMapping.putPulling(sourceActionId,Constants.ROOT + targetName,Constants.ROOT + sourceName);
                    }
//                    else {
//                        if (!sourceActionId.equals(rootAction)) {
//                            actions.remove(sourceActionId);
//                            actionMetadatas.remove(sourceActionId);
//                        }
//                    }
                }
            }
        }

        //遍历target分组
        //暂时不用实现casewhen的层级映射
        for (Map.Entry<String,List<SwitchDependencyAndMapsDTO>> targetEntry : querySwitchResultGroups.entrySet()) {
            List<SwitchDependencyAndMapsDTO> targetSwitchList = targetEntry.getValue();
            String targetFieldPath = targetEntry.getKey();
            String targetFieldName = targetFieldPath.substring(targetFieldPath.lastIndexOf(".") + 1);
            String boxPullingPath = targetSwitchList.get(0).getBoxPullingPath(); //targetSwitchList.get(0).get("boxPullingPath").toString();
            String boxPullingActionId = targetSwitchList.get(0).getBoxPullingActionId(); // targetSwitchList.get(0).get("boxPullingActionId").toString();
            if ((existingActionParamNames.contains(targetFieldName) || existingActionParamNames.contains(targetFieldPath))
                    && !paramsFoundDependency.contains(targetFieldPath)) {
                paramsFoundDependency.add(targetFieldPath);
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(targetFieldPath);
                if (existingActionParamNames.contains(targetFieldName)) {
                    paramDTO.setValue(targetFieldName);
                }
                else {
                    paramDTO.setValue(targetFieldPath);
                }
                executionDTO.getParams().add(paramDTO);
            } else {
                if (!paramsFoundDependency.contains(targetFieldPath)) {
                    paramsFoundDependency.add(targetFieldPath);
                    CasePullingActionExecutionParamDTO casePullingParamDTO = new CasePullingActionExecutionParamDTO();
                    casePullingParamDTO.setType(ActionParamTypeEnum.CASE);
                    casePullingParamDTO.setName(targetFieldPath);
                    //setCaseInput
                    //PullingActionExecutionParamDTO caseInput = new PullingActionExecutionParamDTO();
                    Map<String, Object> caseInput = new HashMap<>(4);
                    caseInput.put("source", boxPullingActionId);
                    caseInput.put("type", ActionParamTypeEnum.PULLING);
                    caseInput.put("value", boxPullingPath);
//                caseInput.setName(targetFieldPath + CASE_INPUT_SUFFIX);
//                caseInput.setSource(boxPullingActionId);
//                caseInput.setType(ActionParamTypeEnum.PULLING);
//                caseInput.setValue(boxPullingPath);
                    casePullingParamDTO.setCaseInput(caseInput);
                    TryGenerateAction(boxPullingActionId, tenantId, existingActionParamNames, tenantVersion);
                    //setCaseBranches
                    List<CaseBranchDTO> caseBranchDTOS = new ArrayList<>();
                    //遍历每个target中的分支并设置when和then
                    for (int i = 0; i < targetSwitchList.size(); i++) {
//                        Map<String, Object> targetRoute = targetSwitchList.get(i);
                        SwitchDependencyAndMapsDTO targetRoute = targetSwitchList.get(i);
//                        List<String> sourceActionLabels = (List<String>) targetRoute.get("sourceActionLabels");
                        List<String> sourceActionLabels = targetRoute.getSourceActionLabels(); //Arrays.asList ((String[])targetRoute.get("sourceActionLabels"));
                        String switchName = targetRoute.getSwitchName(); //(String) targetRoute.get("switchName");
                        String sourceActionId = targetRoute.getSourceActionId(); //(String) targetRoute.get("sourceActionId");
                        String sourceFieldPath = targetRoute.getSourceFieldPath(); // (String) targetRoute.get("sourceFieldPath");
                        if (sourceActionLabels.contains(Neo4jConstants.LABEL_ESP_ACTION) ||
                                sourceActionLabels.contains(Neo4jConstants.LABEL_FORMULA_ACTION) ||
                                sourceActionLabels.contains(Neo4jConstants.LABEL_GET_MECHANISM_VARIABLE_ACTION)) {
                            Map<String, Object> when = new HashMap<>(4);
                            //when.put("name", targetFieldPath + CASE_WHEN_SUFFIX + (i + 1));
                            when.put("value", switchName);
                            when.put("type", ActionParamTypeEnum.CONSTANT);
                            //PullingActionExecutionParamDTO then = new PullingActionExecutionParamDTO();
                            Map<String, Object> then = new HashMap<>(4);
                            then.put("source", sourceActionId);
                            then.put("type", ActionParamTypeEnum.PULLING);
                            then.put("value", sourceFieldPath);
                            //then.setType(ActionParamTypeEnum.PULLING);
                            //then.setValue(sourceFieldPath);
                            //then.setName(targetFieldPath + CASE_OUTPUT_SUFFIX + (i + 1));
                            //then.setSource(sourceActionId);
                            CaseBranchDTO caseBranchDTO = new CaseBranchDTO();
                            caseBranchDTO.setWhen(when);
                            caseBranchDTO.setThen(then);
                            caseBranchDTOS.add(caseBranchDTO);
                            TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion);
                        } else {
                            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.unsupportedData") + sourceActionId);
                        }
                    }
                    casePullingParamDTO.setCaseBranches(caseBranchDTOS);
                    executionDTO.getParams().add(casePullingParamDTO);
                }
            }
        }

        ActionRequestDefinitionDTO requestDefinitionDTO = metadataDTO.getRequest();
        for (ApiDataFieldDefinitionDTO definitionDTO : requestDefinitionDTO.getParameters()) {
            List<String> fieldFullPaths = GetFieldFullPath(definitionDTO, null);
            for (String fieldFullPath : fieldFullPaths) {
                String fieldName = fieldFullPath.contains(".") ? fieldFullPath.substring(fieldFullPath.lastIndexOf(".") + 1) : fieldFullPath;
                String targetFieldName = fieldFullPath.contains("#") ? fieldFullPath.substring(fieldFullPath.lastIndexOf("#") + 1) : fieldFullPath;
                if (existingActionParamNames.contains(fieldFullPath)&& !paramsFoundDependency.contains(fieldFullPath)) { //优先比较fullPath
                    paramsFoundDependency.add(fieldFullPath);
                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PARAM);
                    paramDTO.setName(Constants.ROOT + fieldFullPath);
                    paramDTO.setValue(Constants.ROOT + fieldFullPath);
                    levelMapping.put(existingActionParamNames, fieldFullPath);
//                    levelMapping.put(existingActionParamNames, fieldFullPath,ActionParamTypeEnum.PARAM.toString());
                    executionDTO.getParams().add(paramDTO);
                }else if (existingActionParamNames.contains(fieldName)&& !paramsFoundDependency.contains(fieldFullPath) ) {
                    paramsFoundDependency.add(fieldFullPath);
                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PARAM);
                    paramDTO.setName(Constants.ROOT + fieldFullPath);
                    paramDTO.setValue(Constants.ROOT + fieldName);
                    levelMapping.put(existingActionParamNames, fieldFullPath);
//                    levelMapping.put(existingActionParamNames, fieldFullPath,ActionParamTypeEnum.PARAM.toString());
                    executionDTO.getParams().add(paramDTO);
                }
                // API结构平铺后用的#匹配查找栏位
                else if (existingActionParamNames.contains(targetFieldName)
                        && !paramsFoundDependency.contains(fieldFullPath)
                        && !Objects.equals(Boolean.TRUE,effectiveActionParam(fieldFullPath,processedPullingParams))) {
                    paramsFoundDependency.add(fieldFullPath);
                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PARAM);
                    paramDTO.setName(Constants.ROOT + fieldFullPath);
                    paramDTO.setValue(Constants.ROOT + targetFieldName);
                    levelMapping.put(existingActionParamNames, (StringUtils.isNotEmpty(fieldFullPath) ? fieldFullPath.substring(0,fieldFullPath.indexOf(".") + 1) : fieldFullPath) + targetFieldName);
                    executionDTO.getParams().add(paramDTO);
                }
                //当上述匹配处理完后，进行matchField匹配，此方法，会依次匹配fieldFullPath的子路径
                this.matchField(existingActionParamNames, paramsFoundDependency, fieldFullPath, levelMapping, executionDTO);
            }
        }

//        int paramsCount = levelTraverseParamFieldsCount(metadataDTO);
        FieldHanderDTO fieldHanderDTO = levelTraverseParamFieldsHandler(metadataDTO);
        int paramsCount = fieldHanderDTO.getCount();

        //不需要合并集合中的参数，现在sd处理逻辑不支持集合级别，如果要构造对象，必须要有对象中字段的映射关系
        //如果存在未找到来源的参数，再尝试判断是否是来源于某个DataEntity
        //if (paramsFoundDependency.size() < paramsCount) {
//        if (true) {
//            List<EntityDependencyDTO> queryEntityDependencyResults = this.actionRepository.queryEntityDependency(actionId, tenantId);
//            for (EntityDependencyDTO record : queryEntityDependencyResults) {
//                String targetEntityName = record.getTargetEntityName(); //record.get("targetEntityName").toString();
////                if (existingActionParamNames.contains(targetEntityName)&& !paramsFoundDependency.contains(targetEntityName)) {
////                    paramsFoundDependency.add(targetEntityName);
////                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
////                    paramDTO.setType(ActionParamTypeEnum.PARAM);
////                    paramDTO.setName(targetEntityName);
////                    paramDTO.setValue(targetEntityName);
////                    executionDTO.getParams().add(paramDTO);
////                }
//                //处理参数合并
////                ArrayList<Object> targetFieldFullPaths = (ArrayList<Object>)record.get("targetFieldFullPaths");
//                List<String> targetFieldFullPaths = record.getTargetFieldFullPaths(); // Arrays.asList ((Object[])record.get("targetFieldFullPaths"));
//                List<ActionExecutionParamDTO> paramMatched = new ArrayList<>();
//                for (ActionExecutionParamDTO dto : executionDTO.getParams()) {
//                    for (Object targetFieldFullPath : targetFieldFullPaths) {
//                        if (dto.getName().equals(targetFieldFullPath.toString()) && dto.getValue().equals(dto.getName())) {
//                            paramMatched.add(dto);
//                            break;
//                        }
//                    }
//                }
//                if (paramMatched.size() == targetFieldFullPaths.size()) {
//                    paramsFoundDependency.add(targetEntityName);
//                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
//                    paramDTO.setType(ActionParamTypeEnum.PARAM);
//                    paramDTO.setName(Constants.ROOT + targetEntityName);
//                    paramDTO.setValue(Constants.ROOT + targetEntityName);
//                    levelMapping.put(targetEntityName,targetEntityName);
//                    executionDTO.getParams().add(paramDTO);
//                    for (ActionExecutionParamDTO dto : paramMatched) {
//                        executionDTO.getParams().remove(dto);
//                    }
//                    filteredPullingParamSize += paramMatched.size() - 1;
//                }
//            }
//        }

        //如果存在未找到来源的参数，再尝试判断是否有其它含义的词在参数中
        if (paramsFoundDependency.size() + paramsPullingFoundDependency.size() < paramsCount) {
            List<DataFieldAndMapsDTO> queryEntityDependencyResults = this.actionRepository.queryDataFieldAndMaps(actionId, actionTenantId, tenantVersion);
            for (DataFieldAndMapsDTO record : queryEntityDependencyResults) {
                String targetFieldFullPath = record.getTargetFieldFullPath(); //record.get("targetFieldFullPath").toString();
                String mapFieldFullPath = record.getMapFieldFullPath();  //record.get("mapFieldFullPath").toString();
                String mapFieldName = record.getMapFieldName();

                // 如果是已经找到的参数，则跳过
                if (paramsFoundDependency.contains(targetFieldFullPath)
                        || paramsPullingFoundDependency.contains(targetFieldFullPath)) {
                    continue;
                }
                //record.get("mapFieldName").toString();
                String existingActionParamMatched = null;
                List<String> sourceIds = this.actionRepository.queryActionIdByRequiredField(String.valueOf(record.getMapFieldId()), actionTenantId, tenantVersion);
                for (String existingActionParamName : existingActionParamNames) {
                    String paramName = existingActionParamName.contains(".") ? existingActionParamName.substring(existingActionParamName.lastIndexOf(".") + 1) : existingActionParamName;
                    if ((paramName.equals(mapFieldName) || existingActionParamName.equals(mapFieldFullPath))
                            && (CollectionUtils.isEmpty(sourceIds) || sourceIds.contains(rootAction))) {
                        existingActionParamMatched = existingActionParamName;
                        break;
                    }
                }
                if (existingActionParamMatched != null && !paramsFoundDependency.contains(targetFieldFullPath)) {
                    paramsFoundDependency.add(targetFieldFullPath);
                    ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PARAM);
                    paramDTO.setName(Constants.ROOT + targetFieldFullPath);
                    paramDTO.setValue(Constants.ROOT + existingActionParamMatched);
                    levelMapping.put(existingActionParamMatched, targetFieldFullPath);
                    executionDTO.getParams().add(paramDTO);
                }
            }
        }
        //查找existsParam中是否有不是field级别的参数
        List<EntityDependencyDTO> entityDependencyDTOList = this.actionRepository.queryEntityDependency(actionId, actionTenantId, tenantVersion);
        for(EntityDependencyDTO entityDependencyDTO : entityDependencyDTOList){
            String entityFullPath = entityDependencyDTO.getTargetEntityFullPath();
            if (existingActionParamNames.contains(entityFullPath)&& !paramsFoundDependency.contains(entityFullPath)) {
                paramsFoundDependency.add(entityFullPath);
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(Constants.ROOT + entityFullPath);
                paramDTO.setValue(Constants.ROOT + entityFullPath);
                levelMapping.put(existingActionParamNames, entityFullPath);
//                levelMapping.put(existingActionParamNames, entityFullPath,ActionParamTypeEnum.PARAM.toString());
                executionDTO.getParams().add(paramDTO);
                filteredPullingParamSize += entityDependencyDTO.getTargetFieldFullPaths().size() - 1;
            }
        }

        boolean pullingSucceeded = paramsFoundDependency.size() + paramsPullingFoundDependency.size() + filteredPullingParamSize >= paramsCount;
        pullingSucceeded = pullingSucceeded ? true : hasFoundAllRequiredParams(paramsFoundDependency, paramsPullingFoundDependency, fieldHanderDTO.getRequiredFieldFullPathSet());
        //清理不能作为来源的action和metadata
        //清理逻辑只会发生在第二层或更深层次的路径中，目的是清理无用路径，特别是有多条备选路径时，只有存在来源的路径才是有效的，别的都是无效结果。
        //但如果是第一层，即使param没有都获取到，也需要把已获取的结果返回，这些未取到的结果再由调用方判断给默认值、重新获取还是放弃调用等。
        if (!pullingSucceeded && !actionId.equals(rootAction)) {
            for (String sourceActionId : processedPullingSourceActionIds) {
                if (sourceActionId.equals(rootAction)) {
                    continue;
                }
                actions.remove(sourceActionId);
                actionMetadatas.remove(sourceActionId);
                visitedActionIds.remove(sourceActionId);
            }
            actions.remove(actionId);
            actionMetadatas.remove(actionId);

            visitedActionIds.replace(actionId, false);
        }
        else {
            List<ActionExecutionParamDTO> levelMappings = levelMapping.generate();
            //看是否存在多路径，如果存在，转成多路径的结构
            Map<String, List<PullingActionExecutionParamDTO>> afterGroupingPulling = processedPullingParams.stream().collect(Collectors.groupingBy(e -> e.getName()));
            for(Map.Entry<String, List<PullingActionExecutionParamDTO>> entry : afterGroupingPulling.entrySet()){
                if(entry.getValue().size() > 1){
                    MultiPathActionExecutionParamDTO multiPathActionExecutionParamDTO = new MultiPathActionExecutionParamDTO();
                    multiPathActionExecutionParamDTO.setName(entry.getKey());
                    multiPathActionExecutionParamDTO.setType(ActionParamTypeEnum.MULTIPATH);
                    multiPathActionExecutionParamDTO.setValues(entry.getValue());
                    executionDTO.getParams().add(multiPathActionExecutionParamDTO);
                }else{
                    executionDTO.getParams().addAll(entry.getValue());
                }
            }
//            executionDTO.getParams().addAll(processedPullingParams);
            if(!CollectionUtils.isEmpty(executionDTO.getParams())){
                executionDTO.getParams().addAll(levelMappings);
            }
            visitedActionIds.replace(actionId, true);
        }
        return pullingSucceeded;
    }

    // 判断是否已经找到依赖的参数
    private boolean effectiveActionParam(String fieldFullPath,List<PullingActionExecutionParamDTO> processedPullingParams) {
        if (CollectionUtils.isEmpty(processedPullingParams)) {
            return Boolean.FALSE;
        }
        for (PullingActionExecutionParamDTO pullingActionParam : processedPullingParams) {
            if (StringUtils.equals(Constants.ROOT + fieldFullPath,pullingActionParam.getName())) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }


    private void matchField(List<String> existingActionParamNames,  Set<String> paramsFoundDependency, String fieldFullPath,LevelMapping levelMapping,ActionExecutionDTO executionDTO){
        if(StringUtils.isEmpty(fieldFullPath)){
            return;
        }
        String path = fieldFullPath;
        while(StringUtils.isNotEmpty(path) && !paramsFoundDependency.contains(path)){
            if (existingActionParamNames.contains(path)&& !paramsFoundDependency.contains(path)) {
                paramsFoundDependency.add(fieldFullPath);
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(Constants.ROOT + fieldFullPath);
                paramDTO.setValue(Constants.ROOT + path);
                levelMapping.put(path, fieldFullPath);
                executionDTO.getParams().add(paramDTO);
                return;
            }
            path = StringUtils.substringAfter(path, ".");
        }

        return;
    }

    private List<String> GetFieldFullPath(ApiDataFieldDefinitionDTO fieldDTO, String path) {
        String name = fieldDTO.getData_name();
        if (path != null) {
            name = path + "." + name;
        }
        List<String> fieldFullPaths = new ArrayList<>();
        if (fieldDTO.getField() != null && fieldDTO.getField().size() != 0) {
            for (ApiDataFieldDefinitionDTO detailField : fieldDTO.getField()) {
                fieldFullPaths.addAll(GetFieldFullPath(detailField, name));
            }
        }
        else {
            fieldFullPaths.add(name);
        }
        return fieldFullPaths;
    }

    public String QueryAndPutCurrentAction(String actionId, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = this.actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion);
        actionAndLabels = MergeUtil.excludeWithSameCode(actionAndLabels,
                actionLabel -> actionLabel.getAction().getActionId(),
                actionLabel -> actionLabel.getAction().getSourceLevel());

        if(actionAndLabels.isEmpty()){
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound",actionId,tenantId));
        }
        ActionLabel actionLabel = actionAndLabels.get(0);
//        //从mongo中查询元数据并放入actionMathced中()
//        ActionMetadata actionMetadataByActionId = actionMetadataDAO.getActionMetadataByActionId(actionId);
//        if(null!=actionMetadataByActionId){
//            actionLabel.getAction().setRequest_parameters(JSON.toJSONString(actionMetadataByActionId.getRequestParameters()));
//            actionLabel.getAction().setResponse_object(JSON.toJSONString(actionMetadataByActionId.getResponseObject()));
//        }
        Map<String, Object> actionMatched = JSONObject.parseObject(JSONObject.toJSONString(actionLabel.getAction()), Map.class);
        String currentActionTenantId = MapUtil.getStr(actionMatched, Constants.TENANT_ID);
        actionMatched.put(Constants.TENANT_ID, tenantId);
        List<String> actionLabels = actionLabel.getActionLabels();
        actionMetadatas.put(actionId, this.actionClient.doHandlerMetadata(actionLabels, actionMatched));
        actions.put(actionId, this.actionClient.doHandlerExecution(actionLabels, actionMatched));
        return currentActionTenantId;
    }

    private boolean hasFoundAllRequiredParams(Set<String> paramsFoundDependency, Set<String> requiredFieldFullPathSet){
        if(CollectionUtils.isEmpty(requiredFieldFullPathSet)){
            return true;
        }
        Iterator<String> iterator = requiredFieldFullPathSet.iterator();
        while(iterator.hasNext()){
            String next = iterator.next();
            if(paramsFoundDependency.contains(next)){
                iterator.remove();
            }
        }
        return CollectionUtils.isEmpty(requiredFieldFullPathSet);
    }

    private boolean hasFoundAllRequiredParams(Set<String> paramsFoundDependency, Set<String> paramsPullingFoundDependency, Set<String> requiredFieldFullPathSet){
        if(CollectionUtils.isEmpty(requiredFieldFullPathSet)){
            return true;
        }
        Iterator<String> iterator = requiredFieldFullPathSet.iterator();
        while(iterator.hasNext()){
            String next = iterator.next();
            if(paramsFoundDependency.contains(next)){
                iterator.remove();
            }
            if(paramsPullingFoundDependency.contains(next)){
                iterator.remove();
            }
        }
        return CollectionUtils.isEmpty(requiredFieldFullPathSet);
    }

    private FieldHanderDTO levelTraverseParamFieldsHandler(ActionDefinitionDTO metadataDTO) {
        int count = 0;
        Set<String> requiredFieldFullPath = new HashSet();
        Map<String, String> prefixPathMap = new HashMap<>();
        Queue<ApiDataFieldDefinitionDTO> queue = new LinkedList<>();
        List<ApiDataFieldDefinitionDTO> parameters = metadataDTO.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            if (parameter.getData_type().equals("object")) {
                queue.offer(parameter);
                prefixPathMap.put(parameter.getData_name(), parameter.getData_name() + ".");
            } else {
                count++;
                if(StringUtils.equalsIgnoreCase(parameter.getRequired(), "true")){
                    requiredFieldFullPath.add(parameter.getData_name());
                }
            }
        }
        while (!queue.isEmpty()) {
            ApiDataFieldDefinitionDTO dto = queue.poll();
            String prefix = prefixPathMap.getOrDefault(dto.getData_name(), "");
            for (ApiDataFieldDefinitionDTO parameter : dto.getField()) {
                if (parameter.getData_type().equals("object")) {
                    queue.offer(parameter);
                    prefixPathMap.put(parameter.getData_name(), prefix + parameter.getData_name() + ".");
                } else {
                    count++;
                    if(StringUtils.equalsIgnoreCase(parameter.getRequired(), "true")){
                        requiredFieldFullPath.add(prefix + parameter.getData_name());
                    }
                }
            }
        }
        return new FieldHanderDTO(count, requiredFieldFullPath);
    }

    private int levelTraverseParamFieldsCount(ActionDefinitionDTO metadataDTO) {
        int count = 0;
        Queue<ApiDataFieldDefinitionDTO> queue = new LinkedList<>();
        List<ApiDataFieldDefinitionDTO> parameters = metadataDTO.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            if (parameter.getData_type().equals("object")) {
                queue.offer(parameter);
            } else {
                count++;
            }
        }
        while (!queue.isEmpty()) {
            ApiDataFieldDefinitionDTO dto = queue.poll();
            for (ApiDataFieldDefinitionDTO parameter : dto.getField()) {
                if (parameter.getData_type().equals("object")) {
                    queue.offer(parameter);
                } else {
                    count++;
                }
            }
        }
        return count;
    }

    private static int countParamFields(ActionDefinitionDTO metadata) {
        int count = 0;
        List<ApiDataFieldDefinitionDTO> parameters = metadata.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            count += countParamFields(parameter);
        }
        return count;
    }

    private static int countParamFields(ApiDataFieldDefinitionDTO field) {
        int count = 0;
        if (field.getData_type().equals("object")) {
            for (ApiDataFieldDefinitionDTO parameter : field.getField()) {
                count += countParamFields(parameter);
            }
            return count;
        }
        else {
            return 1;
        }
    }

    private boolean effectiveAction(List<String> sourceActionLabels){
        return sourceActionLabels.contains(Neo4jConstants.LABEL_ESP_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_FORMULA_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_GET_MECHANISM_VARIABLE_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_IAM_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_EOC_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_TASK_DATA_GROUP_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_DATA_PULLING_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_START_SERVICE_COMPOSER_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_START_DATA_EVENT_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_TRANS_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_MICRO_TRANS_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_BMD_GENERAL_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_BMD_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_FORMULAC_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_SQL_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_METRIC_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_BMD_API_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_INPUT_ACTION) ||
                sourceActionLabels.contains(Neo4jConstants.LABEL_BIZ_PARAM_ACTION);

    }

}
