package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ThirdPartyActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class ThirdPartyActionHandlerImpl implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        return new ThirdPartyActionMetadataGenerator().Generate(actionMatched);
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        ThirdPartyActionExecutionDTO executionDTO = new ThirdPartyActionExecutionDTO();
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setType(ActionTypeEnum.THIRD_PARTY);
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.THIRD_PARTY_ACTION;
    }
}
