package com.digiwin.athena.kmservice.cache.old;

import java.lang.annotation.*;

@Target({ ElementType.PARAMETER, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Cache {
    /**
     * redis的数据类型
     * @return
     */
    RedisDataType dataType() default RedisDataType.STRING;

    /**
     * true时，数据库查询不到数据会在redis放入空对象
     * @return
     */
    boolean loadEmpty() default false;

    String namespace() default "km";

    String key();

    /**
     * 语言别是否开启
     *
     * @return
     */
    boolean language() default false;
    /**
     * 租户是否开启
     *
     * @return
     */
    boolean tenant() default false;
    /**
     * 过期时间，单位秒， 默认则没有过期时间
     * @return
     */
    long ttlSecs() default 0L;

    boolean useParamIndex() default false;

    /**
     * 应用是否开启
     *
     * @return
     */
    boolean application() default false;
}
