package com.digiwin.athena.kmservice.dtd;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.constants.DataMapDb;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.service.KmTenantService;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import com.mongodb.client.MongoClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-15 13:33
 **/
@Service("dataMapDataPickService")
@Slf4j
public class DataMapDataPickService extends DataPickService implements InitializingBean {

    MongoTemplate datamapMongoTemplate;

    MongoTemplate datamapTenantMongoTemplate;

    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier("mappingMongoConverterSystem")
    MappingMongoConverter mappingMongoConverterSystem;

    @Autowired
    private KmTenantService kmTenantService;

    @Autowired
    KmApplicationService kmApplicationService;

    public static List<Class> tenantClasses = Arrays.asList(ErpSyncRecord.class, TaskSchedule.class,
            MechanismDecision.class, MechanismDecisionTarget.class, PluginRecord.class, PluginBinding.class);

    public static List<Class> sysClasses = Arrays.asList(Erp2FormInfo.class);

    @Override
    public MongoTemplate systemTemplate() {
        return datamapMongoTemplate;
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return datamapTenantMongoTemplate;
    }

    @Override
    public String tenantVersion(String tenantId) {
        return kmTenantService.getTenantVersion(tenantId);
    }

    @Override
    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<>();
        try {
            String version = tenantVersion();
            codes = kmApplicationService.getCodeByTypeAndAppCodeAndVersion(type, app, version);
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }
        return codes;
    }

    @Override
    public boolean isTenantCol(Class c) {
        return tenantClasses.contains(c);
    }

    @Override
    public boolean isSystemCol(Class c) {
        return sysClasses.contains(c);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SimpleMongoClientDatabaseFactory mongoDbFactory = new SimpleMongoClientDatabaseFactory (mongo, DataMapDb.DATAMAP.getValue());
        datamapMongoTemplate = new MongoTemplate(mongoDbFactory, mappingMongoConverterSystem);
        SimpleMongoClientDatabaseFactory  mongoDbFactoryTenant = new SimpleMongoClientDatabaseFactory (mongo, DataMapDb.DATAMAPTENANT.getValue());
        datamapTenantMongoTemplate = new MongoTemplate(mongoDbFactoryTenant, mappingMongoConverterSystem);
    }
}
