package com.digiwin.athena.kmservice.service;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.cache.CacheConfig;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.povo.CleanCacheReq;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.*;

@Slf4j
@Service
public class KmGeneralService {

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    @Qualifier("commonRestTemplate")
    private RestTemplate restTemplate;


    public Integer cleanCache(CleanCacheReq req){
        Integer count = 0;
        if(null==req.getCleanType() || 0==req.getCleanType()){
            count = deleteKeys(CacheConfig.cachePrefixWord+"*");
        }
        if(1==req.getCleanType() && null!=req.getTenants() ){
            for(String tenantId:req.getTenants()){
                count = count+ deleteKeys(CacheConfig.cachePrefixWord+tenantId+":*");
            }
        }
        if(2==req.getCleanType() && null!=req.getPatterns()){
            for(String pattern:req.getPatterns()){
                count = count+ deleteKeys(pattern);
            }
        }

        return count;
    }

    public Long deleteKeys(List<String> keys) throws Exception {
        final Long delete = this.redisTemplate.delete(keys);
        return delete;
    }


    private Integer deleteKeys(String pattern){
        Set keys =  redisTemplate.keys(pattern);
        redisTemplate.delete(keys);
        return keys.size();
    }

//    public Long blurScanDelete(String matchKey, int count) {
//        return (Long) redisTemplate.execute((RedisCallback<Long>) connection -> {
//            long keyCount = 0;
//            try(Cursor<byte[]> cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count(count).match(matchKey).build())) {
//                long cursorId = cursor.getCursorId();
//                Set<String> keys = new HashSet<>();
//                while (cursor.hasNext()) {
//                    keys.add(new String(cursor.next()));
//                    if (cursorId != cursor.getCursorId()) {
//                        keyCount += keys.size();
//                        // 删除redis缓存
//                        redisTemplate.delete(keys);
//                        // 重置keys集合
//                        keys = new HashSet<>();
//                    }
//                    cursorId = cursor.getCursorId();
//                }
//                // 处理最后一批数据或者唯一一批数据
//                if (cursor.getCursorId() == 0 || CollectionUtils.isNotEmpty(keys)) {
//                    keyCount += keys.size();
//                    // 删除redis缓存
//                    redisTemplate.delete(keys);
//                }
//            } catch (Exception e) {
//                log.error("blurScanDelete failed,{}", e.toString());
//            }
//            return keyCount;
//        });
//    }

    @SuppressWarnings("UnusedReturnValue")
    @Lang
    public <T> List<T> handleLang(List<T> list) {
        return list;
    }

    @SuppressWarnings("UnusedReturnValue")
    @Lang
    public <T> T handleLang(T t) {
        return t;
    }
}
