/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.kg.action.ActionMetadata;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kmservice.service.KmDBCommonService;
import com.digiwin.athena.kmservice.service.KmDBService;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class KmDBCommonServiceImpl
extends KmDBService
implements KmDBCommonService {
    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }

    @Override
    public List<ActionRecast> getActionRecastListByActionIds(List<String> actionIds) {
        return this.systemTemplate().find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds)), ActionRecast.class);
    }

    @Override
    public JSONObject getAgiledataParameterPappingByCodeAndVersion(String code, String version) {
        return (JSONObject)this.systemTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("version").is((Object)version)), JSONObject.class, "agiledata_parameter_mapping");
    }

    @Override
    public ActionMetadata getActionMetadataByActionId(String actionId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        return (ActionMetadata)this.systemTemplate().findOne(query, ActionMetadata.class);
    }
}

