package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.StartServiceComposerActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class StartServiceComposerHandlerImpl implements ActionHandler<Map<String, Object>> {

    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new StartServiceComposerActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        StartServiceComposerActionExecutionDTO executionDTO = new StartServiceComposerActionExecutionDTO();
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setForEach((boolean)actionMatched.getOrDefault("split", false));
        executionDTO.setType(ActionTypeEnum.START_SERVICECOMPOSER);
        executionDTO.setLocale(actionMatched.get("locale").toString());
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_START_SERVICE_COMPOSER_ACTION;
    }
}
