package com.digiwin.athena.kmservice.action.model;

import com.alibaba.fastjson.JSON;

import java.util.List;

public class LogDto {
    private String message;
    private String key = LogConstant.DEFAULT_KEY;
    private List<LogDataDto> data;

    public LogDto() {
    }

    public LogDto(String message, List<LogDataDto> data) {
        this.message = message;
        this.data = data;
    }

    public LogDto(String message, String key) {
        this.message = message;
        this.key = LogConstant.SOURCE_KEY + ";" + key;
    }

    public LogDto(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<LogDataDto> getData() {
        return data;
    }

    public void setData(List<LogDataDto> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
