package com.digiwin.athena.kmservice.configuration;

import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentRead;
import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentWrite;
import com.digiwin.athena.kmservice.configuration.mongoConvert.MechanismCapacityReadConverter;
import com.digiwin.athena.kmservice.configuration.mongoConvert.StructuredComponentRead;

import com.mongodb.MongoClientOptions;
import com.mongodb.client.MongoClient;
import com.mongodb.event.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;

import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.*;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

import java.util.ArrayList;
import java.util.List;

import java.util.concurrent.atomic.AtomicLong;

@Configuration
public class KmMongoConfiguration extends MongoConfigurationSupport {

    @Value("${spring.data.mongodb.database:null}")
    private String database;

    public static AtomicLong connectCheck = new AtomicLong();
    public static AtomicLong connect = new AtomicLong();
    public static AtomicLong waitQueue = new AtomicLong();



    MongoClient mongoClient;

//    @Primary
//    @Bean
//    public MongoClientOptions mongoClientOptions0() {
//        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
//        builder.connectionsPerHost(500);
//        builder.threadsAllowedToBlockForConnectionMultiplier(10);
//        builder.maxWaitTime(60000);
//        builder.connectTimeout(10000);
//        builder.maxConnectionLifeTime(5*60*1000);
//        builder.addConnectionPoolListener(new ConnectionPoolListener() {
//            @Override
//            public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
//                System.out.println("mongo pool opened "+event.getServerId());
//            }
//
//            @Override
//            public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
//                System.out.println("mongo pool closed "+event.getServerId());
//            }
//
//            @Override
//            public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
//                connectCheck.incrementAndGet();
//
//            }
//
//            @Override
//            public void connectionCheckedIn(ConnectionCheckedInEvent event) {
//                connectCheck.decrementAndGet();
//            }
//
//            //    @Override
//            public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
//                waitQueue.incrementAndGet();
//            }
//
//            //   @Override
//            public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
//                waitQueue.decrementAndGet();
//
//            }
//
//            @Override
//            public void connectionAdded(ConnectionAddedEvent event) {
//                connect.incrementAndGet();
//            }
//
//            @Override
//            public void connectionRemoved(ConnectionRemovedEvent event) {
//                connect.decrementAndGet();
//            }
//        });
//        return builder.build();
//    }

//
//
//    @Bean
//    @ConditionalOnProperty(prefix = "spring.data.mongodb",name = "databaseTenant")
//    public MongoTemplate mongoTemplateTenant(MongoClient mongo) throws Exception {
//        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, getDatabaseTenantName());
//        System.out.println("tenantdb...." + mongoDbFactory.getDb().getName());
//        return new MongoTemplate(mongoDbFactory, mappingMongoConverterSystem(mongoDbFactory));
//    }

    @Bean("mappingMongoConverterSystem")
    public MongoConverter mappingMongoConverterSystem(SimpleMongoClientDatabaseFactory mongoDbFactory,MongoMappingContext mongoMappingContext) throws Exception {

        DbRefResolver dbRefResolver = new DefaultDbRefResolver(mongoDbFactory);
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, mongoMappingContext);
        converter.setCustomConversions(customConversionsFirst());
        return converter;
    }

    @Bean("customConversionsFirst")
    public CustomConversions customConversionsFirst() {
        List<Converter<?, ?>> converterList = new ArrayList<Converter<?, ?>>();
        converterList.add(new ComponentRead());
        converterList.add(new StructuredComponentRead());
        converterList.add(new ComponentWrite());
        converterList.add(new MechanismCapacityReadConverter());
        return new MongoCustomConversions(converterList);
    }

    @Override
    protected String getDatabaseName() {
        return database;
    }

}
