package com.digiwin.athena.kmservice.controller;

import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kmservice.analysis.AnalysisTool;
import com.digiwin.athena.kmservice.analysis.UriAnalysisBean;
import com.digiwin.athena.kmservice.analysis.UriAnalysisFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("kmtest")
public class KmTestController {

   // @Autowired
    MongoTemplate mongoTemplate;

    @Autowired(required = false)
    @Qualifier("mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;
    @Autowired
    UriAnalysisFilter uriAnalysisFilter;

    @GetMapping("test01")
    public String test01(){
        System.out.println(Thread.currentThread().getName()+" test01....");

        return "ok";
    }


    @GetMapping("test02")
    public String test02(){
        System.out.println(Thread.currentThread().getName()+" test02....");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

        ThreadInfo[] infos =threadMXBean.dumpAllThreads(true,true);
        for(ThreadInfo info:infos) {
           long cpuTime = threadMXBean.getThreadCpuTime(info.getThreadId());
            System.out.println(info.getThreadName() +" " + cpuTime);

        }

        return "ok";
    }


    @GetMapping("test03")
    public String test03(){
        System.out.println(Thread.currentThread().getName()+" test013....");

        Task a2 = new Task();
        a2.setCode("code2");
        a2.setName("name2");
        a2.setPattern("pattern2");
        Map<String,Object> config1 = new HashMap<>();
        Map<String,Object> approve1 = new HashMap<>();
        config1.put("param1","value1");
        config1.put("param3","value3");
        config1.put("approve",approve1);
        approve1.put("app1","app0011");
        approve1.put("app3","app0033");
        a2.setConfig(config1);
        a2.setLang(new HashMap<>());
        Map<String,String> nameLang1 = new HashMap<>();
        nameLang1.put("zh_CN","供应商回复1");
        nameLang1.put("zh_TW","供應商回覆1");
        nameLang1.put("en_US","supplier replay1");
        a2.getLang().put("name",nameLang1);
        Map<String,String> markLang = new HashMap<>();
        markLang.put("zh_CN","patternCN");
        markLang.put("zh_TW","patternTW");
        markLang.put("en_US","patternEN");
        a2.getLang().put("pattern",markLang);

        mongoTemplate.save(a2);


        mongoTemplateTenant.save(a2);

        return "ok";
    }



    @GetMapping("startAnalysisUri")
    public String startAnalysisUri(){
        uriAnalysisFilter.startAnalysis();
        return "ok";
    }
    @GetMapping("stopAnalysisUri")
    public String stopAnalysisUri(){
        uriAnalysisFilter.stopAnalysis();
        return "ok";
    }

    @GetMapping("analysisInfo")
    public Object analysisInfo(){
        Map<String,Object> result = new HashMap<>();
        Map<String, UriAnalysisBean> uriInfo = uriAnalysisFilter.uriAnalysisBeanMap();
        Map<String,Object> jvmInfo = AnalysisTool.jvmInfo();
        result.put("requestInfo",uriInfo);
        result.put("jvmInfo",jvmInfo);
        return result;
    }

    @GetMapping("stacktrace")
    public Object stacktrace(){
        return AnalysisTool.threadDump();
    }

}
