package com.digiwin.athena.kmservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kg.action.ActionMetadata;
import com.digiwin.athena.kmservice.service.KmDBCommonService;
import com.digiwin.athena.kmservice.service.KmDBService;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class KmDBCommonServiceImpl extends KmDBService implements KmDBCommonService {

    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }


    @Override
    public List<ActionRecast> getActionRecastListByActionIds(List<String> actionIds) {
        return this.systemTemplate().find(Query.query(Criteria.where("actionId").in(actionIds)), ActionRecast.class);
    }

    @Override
    public JSONObject getAgiledataParameterPappingByCodeAndVersion(String code, String version) {
        return this.systemTemplate().findOne(Query.query(Criteria.where("code").is(code).and("version").is(version)), JSONObject.class,"agiledata_parameter_mapping");
    }

    @Override
    public ActionMetadata getActionMetadataByActionId(String actionId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("actionId").is(actionId));
        return this.systemTemplate().findOne(query, ActionMetadata.class);
    }
}
