/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.configuration;

import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentRead;
import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentWrite;
import com.digiwin.athena.kmservice.configuration.mongoConvert.MechanismCapacityReadConverter;
import com.digiwin.athena.kmservice.configuration.mongoConvert.StructuredComponentRead;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
public class KmMongoConfiguration
extends MongoConfigurationSupport {
    @Value(value="${spring.data.mongodb.database:null}")
    private String database;
    public static AtomicLong connectCheck = new AtomicLong();
    public static AtomicLong connect = new AtomicLong();
    public static AtomicLong waitQueue = new AtomicLong();
    MongoClient mongoClient;

    @Bean(value={"mappingMongoConverterSystem"})
    public MongoConverter mappingMongoConverterSystem(SimpleMongoClientDatabaseFactory mongoDbFactory, MongoMappingContext mongoMappingContext) throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver((MongoDatabaseFactory)mongoDbFactory);
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)mongoMappingContext);
        converter.setCustomConversions(this.customConversionsFirst());
        return converter;
    }

    @Bean(value={"customConversionsFirst"})
    public CustomConversions customConversionsFirst() {
        ArrayList<Object> converterList = new ArrayList<Object>();
        converterList.add(new ComponentRead());
        converterList.add(new StructuredComponentRead());
        converterList.add(new ComponentWrite());
        converterList.add(new MechanismCapacityReadConverter());
        return new MongoCustomConversions(converterList);
    }

    protected String getDatabaseName() {
        return this.database;
    }
}

