/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.locale;

import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=200)
public class LangAspect {
    private static final Logger log = LoggerFactory.getLogger(LangAspect.class);
    private final ThreadLocal<Integer> langHandle = new ThreadLocal();

    @Pointcut(value="@within(com.digiwin.athena.kmservice.locale.Lang)")
    public void pointcut1() {
    }

    @Pointcut(value="@annotation(com.digiwin.athena.kmservice.locale.Lang)")
    public void pointcut2() {
    }

    @Around(value="pointcut1() || pointcut2()")
    public Object processLang(ProceedingJoinPoint jp) throws Throwable {
        try {
            Object object = this.doProcessLang(jp);
            return object;
        }
        finally {
            if (null != this.langHandle.get() && this.langHandle.get() == 0) {
                this.langHandle.remove();
            }
        }
    }

    private Object doProcessLang(ProceedingJoinPoint jp) throws Throwable {
        Object result;
        Integer count = this.langHandle.get();
        count = null == count ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.langHandle.set(count);
        try {
            result = jp.proceed();
        }
        catch (Throwable e) {
            count = count - 1;
            this.langHandle.set(count);
            throw e;
        }
        Integer count2 = this.langHandle.get();
        count2 = count2 - 1;
        this.langHandle.set(count2);
        String lang = ServiceUtils.getLocale();
        if (this.langHandle.get() > 0 || StringUtils.isEmpty((CharSequence)lang)) {
            return result;
        }
        TranslateUtil.dealLangRecusive(result, lang);
        return result;
    }
}

