package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.BmdApiActionDefinitionDTO;

import java.util.Map;
import java.util.Objects;


public class BmdApiActionMetadataGenerator extends ActionMetadataGeneratorBase {
    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        BmdApiActionDefinitionDTO metadataDTO = new BmdApiActionDefinitionDTO();
        metadataDTO.setType(ActionTypeEnum.BMD_API);
        metadataDTO.setServiceName(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_SERVICE_NAME).toString());
        metadataDTO.setUrl(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_URL).toString());
        if (Objects.nonNull(actionQueryResult.get("fixSetting"))) {
            metadataDTO.setFixSetting(actionQueryResult.get("fixSetting"));
        }
        if (Objects.nonNull(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_API_META))) {
            metadataDTO.setApiMeta(actionQueryResult.get(Neo4jConstants.PROPERTY_ESP_ACTION_API_META));
        }
        return metadataDTO;
    }
}
