package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;

import java.util.Map;
import java.util.Objects;

/**
 * @title: BmdGeneralActionMetadataGenerator
 * @author: linc
 * @date 2023/11/22 14:59
 * @version: 1.0
 */
public class BmdGeneralActionMetadataGenerator extends ActionMetadataGeneratorBase {

    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        ActionDefinitionDTO metadataDTO = new ActionDefinitionDTO();
        metadataDTO.setType(ActionTypeEnum.BMD_GENERAL);
        if (Objects.nonNull(actionQueryResult.get("querySchema"))) {
            metadataDTO.setQuerySchema(actionQueryResult.get("querySchema"));
        }
//        if (Objects.nonNull(actionQueryResult.get("productLine"))) {
        metadataDTO.setProductLine(Objects.nonNull(actionQueryResult.get("productLine")) ? actionQueryResult.get("productLine").toString() :  "ERP");
//        }
        return metadataDTO;
    }
}