package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.FormulaActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @title: FormulacActionHandlerImpl
 * @author: linc
 * @date 2024/3/1 14:34
 * @version: 1.0
 */
@Component
public class FormulacActionHandlerImpl implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new FormulacActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        FormulaActionExecutionDTO executionDTO = new FormulaActionExecutionDTO();
        executionDTO.setExpression(actionMatched.get(Neo4jConstants.PROPERTY_FORMULA_ACTION_EXPRESSION).toString());
        executionDTO.setTarget(actionMatched.get(Neo4jConstants.PROPERTY_FORMULA_ACTION_TARGET).toString());
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setForEach(true);
        executionDTO.setType(ActionTypeEnum.FORMULAC);
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_FORMULAC_ACTION;
    }
}
