package com.digiwin.athena.kmservice.configuration.mongoConvert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

public class ComponentRead implements Converter<Document, ComponentBO> {


    @Override
    public StructuredComponentBO convert(Document source) {
        StructuredComponentBO structuredComponentDO = doConvert(source);
        return structuredComponentDO;
    }

    private StructuredComponentBO doConvert(Object obj){
        String jsonStr = JSON.toJSONString(obj);
        JSONObject json = JSON.parseObject(jsonStr);
        String type = json.getString("type");
        Object subComponents = json.get("subComponents");

        if(!ObjectUtils.isEmpty(subComponents)){
            JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(subComponents));
            List<StructuredComponentBO> list = new ArrayList<>();
            for(int i = 0; i< jsonArray.size(); i++){
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(doConvert(jsonObject));
            }
            StructuredComponentBO structuredComponentDO = ComponentUtils.parseObject(type, jsonStr);
            structuredComponentDO.setSubComponents(list);
            return structuredComponentDO;
        }else{
            return ComponentUtils.parseObject(type, jsonStr);
        }
    }

//    //TODO 其他组件类型的转换
//    private StructuredComponentDO parseObject(String type, String jsonStr){
//        if(StringUtils.equals(type, "MechanismPrincipleDetail")){
//            return JSON.parseObject(jsonStr, MechanismPrincipleDetailComponent.class);
//        }else if(StringUtils.equals(type, "MechanismVariable")){
//            return JSON.parseObject(jsonStr, MechanismVariableComponent.class);
//        }
//        return JSON.parseObject(jsonStr, StructuredComponentDO.class);
//    }
}
