package com.digiwin.athena.kmservice.service;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kmservice.cache.Cache;
import com.digiwin.athena.kmservice.cache.CacheConfig;
import com.digiwin.athena.kg.dto.DependencyAndMapsDTO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
//@Lang
@Slf4j
@Service
public class TestServiceService {

    @Autowired(required = false)
    private ActionRepository actionRepository;

    @Async
    public String test01(Integer i){
        System.out.println(Thread.currentThread().getName()+" test01..."+i);


        return "ok"+i;
    }

    @Cache(key = "ctx.tenantId+':projects:'+code+tenantId+ctx.locale")
    public List<Project> projects(String code,String tenantId){

        System.out.println("projects.......");
        List<Project> projects = new ArrayList<>();
        for(int i=0;i<10;i++){
            Project p = new Project();
            p.setCode("code"+i);
            p.setName("项目"+i);
            projects.add(p);
        }

        return projects;
    }


    @Lang
    public Project projects1(String code){
        Project p = new Project();
        p.setCode("code1");
        p.setName("项目1");
        p.setLang(new HashMap<>());
        Map<String,String> nameLang = new HashMap<>();
        nameLang.put("zh_CN","供应商回复cn");
        nameLang.put("zh_TW","供應商回覆tw");
        nameLang.put("en_US","supplier replay");
        p.getLang().put("name",nameLang);
        return p;
    }

    @Cache(key = CacheConfig.cachePrefix_tenantUserLang+"'projects2:'+code+taskCodes")
    @Lang
    public List<Project> projects2(String code,List<String> taskCodes){

        System.out.println("projects2.......");
        List<Project> projects = new ArrayList<>();
        for(int i=0;i<10;i++){
            Project p = new Project();
            p.setCode("code"+i);
            p.setName("项目"+i);
            p.setLang(new HashMap<>());
            Map<String,String> nameLang = new HashMap<>();
            nameLang.put("zh_CN","供应商回复");
            nameLang.put("zh_TW","供應商回覆");
            nameLang.put("en_US","supplier replay");
            p.getLang().put("name",nameLang);
            projects.add(p);
        }

        return projects;
    }



    @SentinelResource(value = "test", blockHandler = "handleException", blockHandlerClass = {ExceptionUtil.class})
    public void test() {
        System.out.println(Thread.currentThread().getName()+" Test "+System.currentTimeMillis());
    }

    // 原函数
    @SentinelResource(value = "hello", blockHandler = "exceptionHandler", fallback = "helloFallback")
    public String hello(long s) {
        return String.format("Hello at %d", s);
    }

    // Fallback 函数，函数签名与原函数一致或加一个 Throwable 类型的参数.
    public String helloFallback(long s) {
        return String.format("Halooooo %d", s);
    }

    // Block 异常处理函数，参数最后多一个 BlockException，其余与原函数一致.
    public String exceptionHandler(long s, BlockException ex) {
        // Do some log here.
        log.error(ex.getMessage(), ex);
        return "Oops, error occurred at " + s;
    }

    public Object getDataInfo(String actionId, String tenantId, String tenantVersion) {
        List<DependencyAndMapsDTO> dependencyAndMapsDTOS = actionRepository.queryDependencyAndMaps(actionId, tenantId, tenantVersion);
        Map<String, Object> dataInfo = new HashMap<>();
        dataInfo.put("dependencyAndMapsDTOS", dependencyAndMapsDTOS);
        return dataInfo;
    }

}
