package com.digiwin.athena.kmservice.utils;


import com.digiwin.athena.domain.common.BaseObject;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Slf4j
public class TranslateUtil {

    static ThreadLocal<Boolean> disAbleLangLocal = new InheritableThreadLocal<>();


    public static void disableLang(Boolean disLang){
        disAbleLangLocal.set(disLang);
    }

    public static boolean isDisableLang(){

        return Boolean.TRUE.equals(disAbleLangLocal.get());
    }
    /*
    todo 注意没有处理对象循环问题
     */
    public static void dealLangRecusive(Object entity,String locale){
        if(null==entity || null==locale || ServiceUtils.isPrimitive(entity.getClass())){return;}
        if(entity instanceof BaseObject){
            dealLang((BaseObject) entity,locale);
            dealFields(entity,locale);
        }else if(entity instanceof Collection){
            Collection collection = (Collection) entity;
            for (Object obj :collection){
                dealLangRecusive(obj,locale);
            }
        }else if(entity.getClass().isArray()){
            Object[] arr = (Object[]) entity;
            for (Object obj :arr){
                dealLangRecusive(obj,locale);
            }
        }else if(entity instanceof Map){
            Map map = (Map) entity;
            // bug 165189 166354 兼容老数据language
            try{
                Map<String,Map> lang = null;
                if (map.get("lang")!=null && map.get("lang") instanceof Map) {
                    lang = (Map<String, Map>) map.get("lang");
                } else if (map.get("language")!=null && map.get("language") instanceof Map) {
                    lang = (Map<String, Map>) map.get("language");
                }
                if(lang!=null){
                    lang.forEach((k,m)->{
                        if(null!=m.get(locale)){
                            map.put(k,m.get(locale));
                        }else{
                            if(null!=m.get(locale.toLowerCase())){
                                map.put(k,m.get(locale));
                            }
                        }
                    });
                }
            }catch (Exception e){
                //吃掉翻译异常
            }
            for( Object obj : map.values()){
                dealLangRecusive(obj,locale);
            }
        }else {
            //复合类型
            dealFields(entity,locale);
        }
    }


    private static void dealFields(Object entity,String locale){
        List<Field> fields = ServiceUtils.getFields(entity.getClass());
        for(Field f :fields){
            f.setAccessible(true);
            try {
                Object obj = f.get(entity);
                dealLangRecusive(obj,locale);
            } catch (IllegalAccessException e) {
                log.error(e.toString());
            }
        }
    }

    private static void dealLang(BaseObject entity, String locale){
        if(null!=entity && null!=locale){
            Map<String,Map<String,String>> lang = entity.getLang();
            // bug 165189 兼容老数据language
            if (null == lang) {
                lang = entity.getLanguage();
            }
            if(null!=lang){
                lang.forEach((k,v)->{
                    if(v!=null){
                        String langName = v.get(locale);
                        if(langName!=null){
                            Method method = ServiceUtils.getSetMethod(entity.getClass(),k);
                            if(null!=method){
                                try {
                                    method.invoke(entity,langName);
                                } catch (Exception e) {
                                    log.error(e.toString());
                                    //忽略异常
                                }
                            }else{
                              //  log.warn("can not find set method by class {} and filed {}",entity.getClass().getName(),k);
                            }

                        }
                    }
                });

                // entity.setLang(null);
            }
        }

    }



}
