/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.execution;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;

@FunctionalInterface
public interface ProductNameGetter {
    public String getProductName();

    public static class MdcProductNameGetter
    implements ProductNameGetter {
        private final ProductNameResolver resolver;
        private final String apiName;
        private final String tenantId;
        private String productName;
        private boolean present;

        public MdcProductNameGetter(ProductNameResolver resolver, String apiName, String tenantId) {
            this.resolver = resolver;
            this.apiName = apiName;
            this.tenantId = tenantId;
        }

        @Override
        public String getProductName() {
            if (!this.present) {
                try {
                    this.productName = this.resolver.getProductName(this.apiName, this.tenantId);
                    this.present = true;
                }
                catch (DWException e) {
                    throw new DWRuntimeException(e.getErrorCode(), e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.productName;
        }
    }
}

