/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.StartProcessActionExecutionDTO;
import com.digiwin.athena.kmservice.action.metadata.ActionHandler;
import com.digiwin.athena.kmservice.action.metadata.StartProcessActionMetadataGenerator;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class StartProcessActionHandlerImpl
implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new StartProcessActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        StartProcessActionExecutionDTO executionDTO = new StartProcessActionExecutionDTO();
        executionDTO.setSubject(actionMatched.get("subject").toString());
        executionDTO.setEmergency(Integer.parseInt(actionMatched.getOrDefault("emergency", 50).toString()));
        executionDTO.setActionId(actionMatched.get("actionId").toString());
        executionDTO.setRequesterId("Athena");
        executionDTO.setForEach((Boolean)actionMatched.getOrDefault("split", false));
        executionDTO.setType(ActionTypeEnum.START_PROCESS);
        if (!ObjectUtils.isEmpty((Object)actionMatched.get("async"))) {
            executionDTO.setAsync(Boolean.parseBoolean(String.valueOf(actionMatched.get("async"))));
        }
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return "StartProcessAction";
    }
}

