/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.aspect;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.container.exceptions.IDWException;
import com.digiwin.app.service.DWServiceChainContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class ExceptionHandlerAspect {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerAspect.class);
    private static final String SUBSTRING = "trace info: me: ";
    public static final String UNKNOWN_CODE = "P.DM.500.9999";
    public static final String PTX_ID = "PtxId";
    public static final String CHAIN_INFO = "chainInfo";

    @Pointcut(value="@within(com.digiwin.athena.kmservice.aspect.MyExceptionHandler)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Exception e) {
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            chainInfo = StringUtils.substringAfter((String)chainInfo, (String)SUBSTRING);
            if (e instanceof IDWException) {
                IDWException exception = (IDWException)e;
                if (!exception.getInstructors().containsKey(CHAIN_INFO) || ObjectUtils.isEmpty(exception.getInstructors().get(CHAIN_INFO))) {
                    exception.getInstructors().put(CHAIN_INFO, chainInfo);
                }
                if (!exception.getInstructors().containsKey(PTX_ID) || exception.getInstructors().get(PTX_ID) == null) {
                    exception.getInstructors().put(PTX_ID, ThreadContext.get((String)PTX_ID));
                }
                if (StringUtils.isEmpty((CharSequence)exception.getErrorCode())) {
                    DWRuntimeException exception2 = new DWRuntimeException(UNKNOWN_CODE, e.getMessage());
                    exception2.getInstructors().putAll(exception.getInstructors());
                    throw exception2;
                }
                throw e;
            }
            log.error("pointcut catch exception:{}", (Throwable)e);
            DWRuntimeException exception = new DWRuntimeException(UNKNOWN_CODE, e.getMessage());
            exception.getInstructors().put(CHAIN_INFO, chainInfo);
            exception.getInstructors().put(PTX_ID, ThreadContext.get((String)PTX_ID));
            throw exception;
        }
    }
}

