/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.dtd;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.definition.features.DataTagging;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TaskPathResp;
import com.digiwin.athena.dto.TaskPathVo;
import com.digiwin.athena.kmservice.dtd.DataMapDataPickService;
import com.digiwin.athena.kmservice.povo.DataRequest;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DtdService {
    @Autowired
    @Qualifier(value="dataMapDataPickService")
    private DataMapDataPickService dataPickService;
    @Autowired
    KmApplicationService kmApplicationService;

    public Project getProjectByCode(String code) throws DWException {
        Project p = this.dataPickService.findBetter(code, Project.class);
        return p;
    }

    public Project getUserProject(String projectCode, String stateCode) throws DWException {
        Project up = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("primaryProjectCode", projectCode);
        param.put("init.code", stateCode);
        param.put("executeType", "user");
        up = this.dataPickService.findOne(BasicQuery.of(param, null), Project.class);
        return up;
    }

    public DataState getDataState(String code) throws DWException {
        return this.dataPickService.findByCode(code, DataState.class);
    }

    public TaskPathResp postExecutePath(DataRequest request) throws DWException {
        ServiceUtils.getContext().setEocInfo(request.getEocInfo());
        TaskPathResp resp = new TaskPathResp();
        String tenantId = ServiceUtils.getTenantId();
        request.setTenantId(tenantId);
        Project pro = this.getProjectByCode(request.getProjectCode());
        if (null == pro) {
            throw new DWException("P.DM.500.0001", I18nUtils.getValue("P.DM.500.0001", new Object[0]) + request);
        }
        String topProjectCode = pro.getCode();
        if (null != pro.getPrimaryProjectCode()) {
            topProjectCode = pro.getPrimaryProjectCode();
        }
        Application application = this.kmApplicationService.applicationByCodeAndVersion(pro.getApplication(), this.dataPickService.tenantVersion());
        boolean individualAll = Optional.ofNullable(application).map(Application::getIndividualAll).orElse(false);
        Project up = this.getUserProject(topProjectCode, request.getFromStateCode());
        resp.setStartProject(up);
        DataState begin = this.getDataState(request.getFromStateCode());
        resp.setFromState(begin);
        if (this.reachProjectEnd(request.getFromStateCode(), request.getToStateCode(), pro)) {
            return resp;
        }
        List<Task> tasks = this.bestTaskByFrom(request.getFromStateCode(), request);
        if (!tasks.isEmpty()) {
            HashMap groups = new HashMap();
            tasks.removeIf(t -> individualAll && "SYSTEM".equals(t.getTenantId()));
            tasks.forEach(t -> {
                if (null == t.getGroup()) {
                    t.setGroup("default");
                }
                groups.computeIfAbsent(t.getGroup(), k -> new ArrayList()).add(t);
            });
            for (Map.Entry entry : groups.entrySet()) {
                List v = (List)entry.getValue();
                this.sortTasks(v, request);
                TaskPathVo vo = new TaskPathVo();
                vo.setTasks(v);
                Task first = (Task)v.get(0);
                first = this.fillTaskDetail(first);
                this.dealFeatures(first);
                vo.setTask(first);
                v.set(0, first);
                resp.getPaths().add(vo);
            }
        }
        return resp;
    }

    private void dealFeatures(Task detail) {
        if (null == detail) {
            return;
        }
        detail.setFeatures(detail.getFeeInfo());
    }

    private Task fillTaskDetail(Task task) throws DWException {
        if (task == null) {
            return null;
        }
        if (null != (task = this.dataPickService.findBetter(task.getCode(), Task.class)).getFlowCode()) {
            FlowGraph graph = this.dataPickService.findByCode(task.getFlowCode(), FlowGraph.class);
            task.setFlow(graph);
        }
        return task;
    }

    private List<Task> bestTaskByFrom(String from, DataRequest request) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(from);
        HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
        param.put("from", codes);
        List<Task> tasks = this.dataPickService.find(BasicQuery.of(param, request.getEocInfo()), Task.class);
        tasks.forEach(task -> {
            for (StateMap sm : task.getStateMaps()) {
                if (!from.equals(sm.getInput())) continue;
                if (null == sm.getGroup()) break;
                task.setGroup(sm.getGroup());
                break;
            }
        });
        return tasks;
    }

    private void sortTasks(List<Task> tasks, DataRequest request) {
        for (Task t : tasks) {
            if (null == t.getPriority()) {
                t.setPriority(Integer.valueOf(0));
            }
            if (null == t.getScore()) {
                t.setScore(Integer.valueOf(0));
            }
            t.setScore(Integer.valueOf(t.getPriority() * 100 + t.getScore()));
            if (!CollectionUtils.isNotEmpty((Collection)t.getDataFeatures()) || request.getDateFeatures().isEmpty()) continue;
            for (DataTagging dt : t.getDataFeatures()) {
                if (!request.getDateFeatures().contains(dt.getCode())) continue;
                t.setScore(Integer.valueOf(t.getScore() + dt.getWeight()));
            }
        }
        tasks.sort((o1, o2) -> o2.getScore() - o1.getScore());
    }

    private boolean reachProjectEnd(String current, String to, Project project) {
        if (to.equals(current)) {
            return true;
        }
        if (null != project.getEnds()) {
            for (DataState state : project.getEnds()) {
                if (!state.getCode().equals(current)) continue;
                return true;
            }
        }
        return false;
    }
}

