/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.execution;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.monitorRule.TenantServiceConfig;
import com.digiwin.athena.kmservice.action.execution.ESPConfiguration;
import com.digiwin.athena.kmservice.povo.productOperation.ProductOperationResult;
import com.digiwin.athena.kmservice.service.KmTenantService;
import com.digiwin.athena.kmservice.utils.GsonUtils;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.KmHttpUtil;
import com.google.gson.reflect.TypeToken;
import com.jugg.agile.framework.core.dapper.alarm.JaAlarmMessage;
import com.jugg.agile.framework.core.dapper.alarm.adapter.qywx.JaQyWxAlarm;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ProductNameResolver {
    private static Logger LOGGER = LoggerFactory.getLogger(ProductNameResolver.class);
    @Autowired
    KmTenantService kmTenantService;
    @Autowired
    @Qualifier(value="commonRestTemplate")
    RestTemplate restTemplate;
    private static final JaQyWxAlarm jaQyWxAlarm = new JaQyWxAlarm("Mdc");

    public String[] getPrioritizedProductList(String serviceName) {
        TenantServiceConfig serviceConfig = this.kmTenantService.getTenantServiceConfigByServiceName(serviceName);
        return serviceConfig == null || StringUtils.isEmpty((CharSequence)serviceConfig.getProductName()) ? null : StringUtils.split((String)serviceConfig.getProductName(), (String)",");
    }

    private String getMatchedSystemProduct(List<String> tenantProductList, String serviceName) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tenantProductList)) {
            return null;
        }
        String[] prioritizedProductList = this.getPrioritizedProductList(serviceName);
        if (prioritizedProductList == null) {
            return null;
        }
        for (int i = 0; i < prioritizedProductList.length; ++i) {
            if (!tenantProductList.contains(prioritizedProductList[i])) continue;
            return prioritizedProductList[i];
        }
        return null;
    }

    public List<String> getCloudProductNames(String tenantId) throws Exception {
        LOGGER.info("getCloudProductNames  tenantId:{}", (Object)tenantId);
        ArrayList<String> productNameList = new ArrayList<String>();
        try {
            JSONObject response = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)this.tenantProductList(tenantId, null)), JSONObject.class);
            LOGGER.info("tenantProductOperationList response:{}", (Object)response);
            JSONArray gateways = response.getJSONObject("data").getJSONArray("gateway");
            boolean found = false;
            for (Object gateway : gateways) {
                JSONArray products = ((JSONObject)gateway).getJSONArray("product");
                for (Object product : products) {
                    productNameList.add(((JSONObject)product).getString("name"));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("getCloudProductNames error:{}", (Throwable)e);
        }
        return productNameList;
    }

    public List<String> getCloudProductNamesWithRetry(String tenantId, int maxRetry) throws Exception {
        List<String> cloudProductNames = null;
        try {
            cloudProductNames = this.getCloudProductNames(tenantId);
        }
        catch (Exception e) {
            String message = JaAlarmMessage.getCommonMessage();
            message = message + "getCloudProductNamesWithRetry2,Retry=" + maxRetry;
            message = message + e.toString();
            jaQyWxAlarm.alarm(message);
            if (maxRetry > 0) {
                TimeUnit.MILLISECONDS.sleep(50L);
                LOGGER.info("getCloudProductNamesWithRetry error, begin retry max retry:{} , time:{}", (Object)maxRetry, (Object)LocalDateTime.now());
                cloudProductNames = this.getCloudProductNamesWithRetry(tenantId, --maxRetry);
            }
            LOGGER.error("getCloudProductNamesWithRetryError:{}", (Throwable)e);
            throw new DWException("P.MDC.500.9999", I18nUtils.getValue("knowledgegraph.knowledgegraphError", new Object[0]) + e.getMessage(), (Throwable)e);
        }
        return cloudProductNames;
    }

    public List<String> getCloudProductNamesAfterEocSet(String tenantId) throws Exception {
        LOGGER.info("getCloudProductNamesAfterEocSet  tenantId:{}", (Object)tenantId);
        ArrayList<String> productNameList = new ArrayList<String>();
        try {
            JSONObject response = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)this.tenantProductOperationList(tenantId)), JSONObject.class);
            LOGGER.info("tenantProductOperationList response:{}", (Object)response);
            JSONArray gateways = response.getJSONArray("prod_eoc_mapping");
            if (gateways == null) {
                return productNameList;
            }
            HashSet<String> prodcutSet = new HashSet<String>();
            for (Object gateway : gateways) {
                String product = ((JSONObject)gateway).getString("prod_name");
                if (prodcutSet.contains(product)) continue;
                productNameList.add(product);
                prodcutSet.add(product);
            }
        }
        catch (IOException e) {
            LOGGER.error("TenantProductOperationListError:{}", (Throwable)e);
        }
        return productNameList;
    }

    public Object tenantProductList(String tenantId, String serviceName) throws Exception {
        LOGGER.info("tenantProductList  tenantId:{}", (Object)tenantId);
        String apiMetadataUrl = ESPConfiguration.getEspMdcUrl() + "/restful/standard/mdc/TenantProductList/Get";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        KmHttpUtil.requiredHeaders(headers);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenant_id", tenantId);
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            requestMap.put("api_name", serviceName);
        }
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(apiMetadataUrl, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        LOGGER.info("tenantProductListResponse  tenantId:{}, response:{}", (Object)tenantId, body);
        return body;
    }

    public Object batchTenantProductList(String tenantId, List<String> serviceNames) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tenantId) || org.apache.commons.collections.CollectionUtils.isEmpty(serviceNames)) {
            return null;
        }
        LOGGER.info("batchTenantProductList tenantId:{}\uff0cserviceNames.size:{}", (Object)tenantId, (Object)serviceNames.size());
        String apiMetadataUrl = ESPConfiguration.getEspMdcUrl() + "/restful/standard/mdc/TenantApiProduct/batch/get";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        KmHttpUtil.requiredHeaders(headers);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("tenantId", tenantId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(serviceNames)) {
            requestMap.put("apiNames", serviceNames);
        }
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(apiMetadataUrl, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
        Object body = resEntity.getBody();
        LOGGER.info("batchTenantProductList Response tenantId:{}, response:{}", (Object)tenantId, body);
        return body;
    }

    public Object tenantProductOperationList(String tenantId) throws Exception {
        try {
            LOGGER.info("tenantProductOperationList  tenantId:{}", (Object)tenantId);
            String apiMetadataUrl = ESPConfiguration.getEspMdcUrl() + "/restful/standard/mdc/TenantProductOperationList/Get";
            HttpHeaders headers = new HttpHeaders();
            KmHttpUtil.requiredHeaders(headers);
            headers.add("Content-Type", "application/json");
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("tenant_id", tenantId);
            HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            ResponseEntity resEntity = this.restTemplate.exchange(apiMetadataUrl, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            Object body = resEntity.getBody();
            LOGGER.info("tenantProductOperationListResponse  tenantId:{}, response:{}", (Object)tenantId, body);
            return body;
        }
        catch (Exception e) {
            String message = JaAlarmMessage.getCommonMessage();
            message = message + "tenantProductOperationList,Retry=1";
            message = message + e.toString();
            jaQyWxAlarm.alarm(message);
            throw e;
        }
    }

    public List<String> getCloudProductNamesWithRetryAfterEocSet(String tenantId, int maxRetry) throws Exception {
        List<String> cloudProductNames = null;
        try {
            cloudProductNames = this.getCloudProductNamesAfterEocSet(tenantId);
        }
        catch (Exception e) {
            String message = JaAlarmMessage.getCommonMessage();
            message = message + "getCloudProductNamesWithRetryAfterEocSet2,Retry=" + maxRetry;
            message = message + e.toString();
            jaQyWxAlarm.alarm(message);
            if (maxRetry > 0) {
                TimeUnit.MILLISECONDS.sleep(50L);
                LOGGER.info("getCloudProductNamesWithRetryAfterEocSet error, begin retry max retry:{} , time:{}", (Object)maxRetry, (Object)LocalDateTime.now());
                cloudProductNames = this.getCloudProductNamesWithRetryAfterEocSet(tenantId, --maxRetry);
            }
            LOGGER.error("getCloudProductNamesWithRetryAfterEocSet:{}", (Throwable)e);
            throw new Exception(I18nUtils.getValue("knowledgegraph.knowledgegraphError", new Object[0]), e);
        }
        return cloudProductNames;
    }

    public Map<String, List<Map<String, String>>> batchGetCloudProductNamesWithRetry(String tenantId, List<String> serviceNames, int maxRetry) throws Exception {
        Map<String, List<Map<String, String>>> serviceProductMap = new HashMap<String, List<Map<String, String>>>();
        LOGGER.info("batchGetCloudProductNamesWithRetry serviceNames:{}, tenantId:{}, maxRetry:{}", new Object[]{JSON.toJSONString(serviceNames), tenantId, maxRetry});
        try {
            JSONObject response = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)this.batchTenantProductList(tenantId, serviceNames)), JSONObject.class);
            LOGGER.info("batchGetCloudProductNamesWithRetry response:{}", (Object)response);
            JSONObject data = response.getJSONObject("data");
            if (data != null) {
                JSONObject serviceProductMapJson = data.getJSONObject("serviceProductMap");
                serviceProductMap = GsonUtils.fromJson(serviceProductMapJson.toJSONString(), new TypeToken<Map<String, List<Map<String, String>>>>(){});
            }
        }
        catch (Exception e) {
            String message = JaAlarmMessage.getCommonMessage();
            message = message + "batchGetCloudProductNamesWithRetry3,Retry=" + maxRetry;
            message = message + e.toString();
            jaQyWxAlarm.alarm(message);
            if (maxRetry > 0) {
                TimeUnit.MILLISECONDS.sleep(1000L);
                LOGGER.info("batchGetCloudProductNamesWithRetry error, begin retry max retry:{} , time:{}", (Object)maxRetry, (Object)LocalDateTime.now());
                serviceProductMap = this.batchGetCloudProductNamesWithRetry(tenantId, serviceNames, --maxRetry);
            }
            LOGGER.error("batchGetCloudProductNamesWithRetry:{}", (Object)e.toString());
            throw new DWBusinessException("P.KG.503.0002", I18nUtils.getValue("knowledgegraph.knowledgegraphError", new Object[0]), (Throwable)e);
        }
        return serviceProductMap;
    }

    public List<String> getCloudProductNames(String serviceName, String tenantId) throws Exception {
        LOGGER.info("getCloudProductNames serviceName:{}, tenantId:{}", (Object)serviceName, (Object)tenantId);
        JSONObject response = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)this.tenantProductList(tenantId, serviceName)), JSONObject.class);
        LOGGER.info("getCloudProductNamesReponse serviceName:{}, tenantId:{} response:{}", new Object[]{serviceName, tenantId, response});
        ArrayList<String> productNameList = new ArrayList<String>();
        JSONObject data = response.getJSONObject("data");
        if (data == null) {
            return productNameList;
        }
        JSONArray gateways = data.getJSONArray("gateway");
        if (gateways == null) {
            return productNameList;
        }
        boolean found = false;
        for (Object gateway : gateways) {
            JSONArray products = ((JSONObject)gateway).getJSONArray("product");
            for (Object product : products) {
                productNameList.add(((JSONObject)product).getString("name"));
            }
        }
        return productNameList;
    }

    public List<String> getCloudProductNamesWithRetry(String serviceName, String tenantId, int maxRetry) throws Exception {
        List<String> cloudProductNames = null;
        try {
            cloudProductNames = this.getCloudProductNames(serviceName, tenantId);
        }
        catch (Exception e) {
            String message = JaAlarmMessage.getCommonMessage();
            message = message + "getCloudProductNamesWithRetry3,Retry=" + maxRetry;
            message = message + e.toString();
            jaQyWxAlarm.alarm(message);
            if (maxRetry > 0) {
                TimeUnit.MILLISECONDS.sleep(1000L);
                LOGGER.info("getCloudProductNamesWithRetry error, begin retry max retry:{} , time:{}", (Object)maxRetry, (Object)LocalDateTime.now());
                cloudProductNames = this.getCloudProductNamesWithRetry(serviceName, tenantId, --maxRetry);
            }
            LOGGER.error("getCloudProductNamesWithRetryError:{}", (Throwable)e);
            throw new DWBusinessException("P.KG.503.0002", I18nUtils.getValue("knowledgegraph.knowledgegraphError", new Object[0]), (Throwable)e);
        }
        return cloudProductNames;
    }

    private void batchSetProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        ArrayList<Map<String, Object>> actionMap = new ArrayList<Map<String, Object>>();
        this.batchMapSetActionMap(data, tenantId, actionMap);
        this.batchSetDataActionProductInfo(actionMap, tenantId);
    }

    public void batchSetProductInfoForList(List<Map<String, Object>> data, String tenantId) throws Exception {
        ArrayList<Map<String, Object>> actionMap = new ArrayList<Map<String, Object>>();
        this.batchListSetActionMap(data, tenantId, actionMap);
        this.batchSetDataActionProductInfo(actionMap, tenantId);
    }

    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                this.batchMapSetActionMap((Map)value, tenantId, actionMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.batchListSetActionMap((List)value, tenantId, actionMap);
        }
    }

    private void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                this.batchMapSetActionMap((Map)item, tenantId, actionMap);
                continue;
            }
            if (!(item instanceof List)) continue;
            this.batchListSetActionMap((List)item, tenantId, actionMap);
        }
    }

    private void batchSetDataActionProductInfo(List<Map<String, Object>> actions, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        if (CollectionUtils.isEmpty(actions = actions.stream().filter(action -> ObjectUtils.isEmpty(action.get("productName")) && "ESP".equalsIgnoreCase(String.valueOf(action.get("type"))) && StringUtils.isNotEmpty((CharSequence)String.valueOf(action.get("serviceName")))).collect(Collectors.toList()))) {
            return;
        }
        List<String> serviceNames = actions.stream().map(action -> String.valueOf(action.get("serviceName"))).distinct().collect(Collectors.toList());
        Map<String, String> serviceNameMap = this.getProductNameMap(tenantId, serviceNames);
        for (Map<String, Object> action2 : actions) {
            action2.put("productName", serviceNameMap.get(String.valueOf(action2.get("serviceName"))));
        }
    }

    public Map<String, String> getProductNameMap(String tenantId, List<String> serviceNames) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tenantId) || org.apache.commons.collections.CollectionUtils.isEmpty(serviceNames)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        int maxRetry = 2;
        int batchCount = 200;
        Map<Object, Object> serviceProductMap = new HashMap();
        if (serviceNames.size() > 200) {
            int page = serviceNames.size() / 200 + (serviceNames.size() % 200 == 0 ? 0 : 1);
            for (int i = 0; i < page; ++i) {
                int startJ = i * 200;
                int endJ = Math.min((i + 1) * 200, serviceNames.size());
                serviceProductMap.putAll(this.batchGetCloudProductNamesWithRetry(tenantId, serviceNames.subList(startJ, endJ), 2));
            }
        } else {
            serviceProductMap = this.batchGetCloudProductNamesWithRetry(tenantId, serviceNames, 2);
        }
        for (Map.Entry<Object, Object> entry : serviceProductMap.entrySet()) {
            String k = (String)entry.getKey();
            List v = (List)entry.getValue();
            if (v.size() == 1) {
                serviceNameMap.put(k, (String)((Map)v.get(0)).get("name"));
                continue;
            }
            if (v.size() > 1) {
                Optional<String> result;
                List<String> cloudProductNames = v.stream().map(item -> (String)item.get("name")).collect(Collectors.toList());
                TenantServiceConfig tenantServiceConfig = this.kmTenantService.findTenantServiceConfig(tenantId, k);
                if (tenantServiceConfig != null && (result = cloudProductNames.stream().filter(str -> str.equals(tenantServiceConfig.getProductName())).findFirst()).isPresent()) {
                    serviceNameMap.put(k, result.get());
                    continue;
                }
                String matchedSystemProduct = this.getMatchedSystemProduct(cloudProductNames, k);
                if (StringUtils.isNotEmpty((CharSequence)matchedSystemProduct)) {
                    serviceNameMap.put(k, matchedSystemProduct);
                    continue;
                }
                throw new DWBusinessException("P.KG.500.0025", I18nUtils.getValue("knowledgegraph.multipleProduct", tenantId, k, cloudProductNames));
            }
            serviceNameMap.put(k, "");
            LOGGER.warn("serviceProductMap \u5b58\u5728\u4ea7\u54c1\u540d\u79f0\u4e3anull\u7684\u95ee\u9898\u6570\u636e tenantId\uff1a{}\uff0c serviceName\uff1a{}", (Object)tenantId, (Object)k);
        }
        return serviceNameMap;
    }

    public String getProductName(String serviceName, String tenantId) throws Exception {
        List<String> cloudProductNames = this.getCloudProductNamesWithRetry(serviceName, tenantId, 2);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(cloudProductNames)) {
            return "";
        }
        if (cloudProductNames.size() == 1) {
            return cloudProductNames.get(0);
        }
        TenantServiceConfig tenantServiceConfig = this.kmTenantService.findTenantServiceConfig(tenantId, serviceName);
        String matchedSystemProduct = this.getMatchedSystemProduct(cloudProductNames, serviceName);
        if (tenantServiceConfig == null) {
            if (StringUtils.isEmpty((CharSequence)matchedSystemProduct)) {
                throw new DWBusinessException("P.KG.500.0025", I18nUtils.getValue("knowledgegraph.multipleProduct", tenantId, serviceName, cloudProductNames));
            }
            return matchedSystemProduct;
        }
        Optional<String> result = cloudProductNames.stream().filter(str -> str.equals(tenantServiceConfig.getProductName())).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        if (StringUtils.isEmpty((CharSequence)matchedSystemProduct)) {
            throw new DWBusinessException("P.KG.500.0025", I18nUtils.getValue("knowledgegraph.multipleProduct", tenantId, serviceName, cloudProductNames));
        }
        return matchedSystemProduct;
    }

    public void setProductNames(String serviceName, String tenantId, String productName) throws Exception {
        boolean changed = false;
        TenantServiceConfig tenantServiceConfig = this.kmTenantService.findTenantServiceConfig(tenantId, serviceName);
        if (tenantServiceConfig == null) {
            changed = true;
            this.kmTenantService.addTenantServiceConfig(tenantId, serviceName, productName);
        } else if (!StringUtils.equals((CharSequence)productName, (CharSequence)tenantServiceConfig.getProductName())) {
            changed = true;
            this.kmTenantService.removeTenantServiceConfig(tenantId, serviceName);
            this.kmTenantService.addTenantServiceConfig(tenantId, serviceName, productName);
        }
        if (changed) {
            String string = "knowledgegraph:SYSTEM:SYSTEM:zh_CN:ProductName$" + tenantId;
        }
    }

    public ProductOperationResult getProductEoc(String tenantId) throws Exception {
        LOGGER.info("getCloudProductNamesAfterEocSet  tenantId:{}", (Object)tenantId);
        JSONObject response = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)this.tenantProductOperationList(tenantId)), JSONObject.class);
        LOGGER.info("tenantProductList response:{}", (Object)response);
        ProductOperationResult productOperationResult = (ProductOperationResult)JSON.parseObject((String)JSON.toJSONString((Object)response), ProductOperationResult.class);
        return productOperationResult;
    }

    public void batchSetProductInfoForTaskView(String tenantId, Map<String, Object> taskView) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        try {
            Map dataSources = (Map)taskView.get("dataSources");
            Map pages = (Map)taskView.get("pages");
            tmp.put("dataSources", dataSources);
            tmp.put("pages", pages);
            Object expectedDurationObj = taskView.get("expectedDuration");
            if (null != expectedDurationObj) {
                Map expectedDuration = null;
                if (expectedDurationObj instanceof Map) {
                    expectedDuration = (Map)expectedDurationObj;
                } else {
                    expectedDuration = JSON.parseObject((String)JSON.toJSONString((Object)expectedDurationObj));
                    taskView.put("expectedDuration", expectedDuration);
                }
                Map dueDateRule = (Map)expectedDuration.get("dueDateRule");
                if (null != dueDateRule) {
                    Map getDateAction = (Map)dueDateRule.get("getDateAction");
                    tmp.put("getDateAction", getDateAction);
                }
            }
            this.batchSetProductInfo(tmp, tenantId);
        }
        catch (Exception e) {
            LOGGER.error("batchSetProductInfoForTaskView error", (Throwable)e);
        }
    }

    static {
        jaQyWxAlarm.setUrl("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=9c7223d0-ff1d-48b4-9059-5a9b6a83575d");
    }
}

