/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kmservice.action.execution.KmDataPullingPathGenerator;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionParamTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ESPActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.MultiPathActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.PullingActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartDataEventActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartProcessActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartServiceComposerActionExecutionDTO;
import com.digiwin.athena.kmservice.action.model.LogDataDto;
import com.digiwin.athena.kmservice.action.model.LogDto;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.KmTenantService;
import com.digiwin.athena.kmservice.service.impl.KmDBCommonServiceImpl;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class ActionExecutionPathService {
    private static final Logger log = LoggerFactory.getLogger(ActionExecutionPathService.class);
    @Autowired
    private KmTenantService kmTenantService;
    @Autowired
    private KmDBCommonServiceImpl kmDBCommonService;
    @Autowired(required=false)
    ActionRepository actionRepository;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    ProductNameResolver productNameResolver;

    public KmDataPullingPathGenerator getDataPullingPathGenerator() {
        KmDataPullingPathGenerator bean = (KmDataPullingPathGenerator)SpringUtil.getBean(KmDataPullingPathGenerator.class);
        return bean;
    }

    public Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams, List<String> existingSysParams) throws Exception {
        try {
            JSONObject actionParamMapping;
            List<Action> actionList;
            String tenantVersion = this.kmTenantService.getTenantVersion(tenantId);
            if (StringUtils.isNotEmpty((CharSequence)actionId) && actionId.startsWith("METRIC_") && !CollectionUtils.isEmpty(actionList = this.actionRepository.findByActionIdAndVersion(actionId, tenantVersion))) {
                actionId = actionList.get(0).getQuoteMetricCode();
            }
            List<String> existingActionParamsWithoutRoot = this.removeActionParamRoot(existingActionParams);
            List<String> existingSysParamsWithoutRoot = this.removeActionParamRoot(existingSysParams);
            List subtractSysParams = (List)CollectionUtils.subtract(existingSysParamsWithoutRoot, existingActionParamsWithoutRoot);
            List existingAllParams = (List)CollectionUtils.union(existingActionParamsWithoutRoot, existingSysParamsWithoutRoot);
            ActionExecutionPathDTO pathDTO = this.getDataPullingPathGenerator().Generate(actionId, tenantId, existingAllParams, tenantVersion);
            this.handleDistinctActions(pathDTO.getActions());
            List<ActionRecast> actionRecast = this.kmDBCommonService.getActionRecastListByActionIds(Collections.singletonList(actionId));
            if (!CollectionUtils.isEmpty(actionRecast)) {
                pathDTO.setRecast(actionRecast.get(0).getRecast());
            }
            if (!ObjectUtils.isEmpty((Object)(actionParamMapping = this.kmDBCommonService.getAgiledataParameterPappingByCodeAndVersion(actionId, tenantVersion)))) {
                pathDTO.setStandardParameterMapping(actionParamMapping.getJSONObject("parameterMapping"));
            }
            this.postActionExecutionProcessor(pathDTO.getActions(), tenantId, subtractSysParams);
            this.logTrace(actionId, true, null);
            return pathDTO;
        }
        catch (Exception e) {
            this.logTrace(actionId, false, e.getMessage());
            throw new Exception(e);
        }
    }

    private List<String> removeActionParamRoot(List<String> existsActionParams) {
        ArrayList<String> actionParamsWithoutRoot = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(existsActionParams)) {
            existsActionParams.forEach(e -> {
                if (e.startsWith("$.")) {
                    actionParamsWithoutRoot.add(e.substring(2));
                } else {
                    actionParamsWithoutRoot.add((String)e);
                }
            });
        }
        return actionParamsWithoutRoot;
    }

    private void handleDistinctActions(List<ActionExecutionDTO> actions) {
        if (!CollectionUtils.isEmpty(actions)) {
            actions.forEach(action -> {
                List<ActionExecutionParamDTO> params = action.getParams();
                ArrayList<ActionExecutionParamDTO> uniqueParams = new ArrayList<ActionExecutionParamDTO>();
                HashSet<String> distinctParams = new HashSet<String>();
                for (ActionExecutionParamDTO param : params) {
                    if (param instanceof PullingActionExecutionParamDTO) {
                        PullingActionExecutionParamDTO pullingParam = (PullingActionExecutionParamDTO)param;
                        String key = this.createKey(pullingParam.getName(), pullingParam.getType().toString(), pullingParam.getValue(), pullingParam.getSource());
                        if (distinctParams.contains(key)) continue;
                        uniqueParams.add(param);
                        distinctParams.add(key);
                        continue;
                    }
                    String key = this.createKey(param.getName(), param.getType().toString(), param.getValue(), null);
                    if (distinctParams.contains(key)) continue;
                    uniqueParams.add(param);
                    distinctParams.add(key);
                }
                action.setParams(uniqueParams);
            });
        }
    }

    private String createKey(String name, String type, String value, String source) {
        return name + type + value + (source != null ? source : "");
    }

    private void logTrace(String actionId, boolean success, String errorMsg) {
        LogDataDto logDataDto = new LogDataDto(actionId, "\u884c\u52a8actionId", "config", "actionId");
        String message = success ? "\u77e5\u8bc6\u56fe\u8c31\u6c42\u53d6\u884c\u52a8\u903b\u8f91\u56fe\u8c31\u6210\u529f" : "\u77e5\u8bc6\u56fe\u8c31\u6c42\u53d6\u884c\u52a8\u903b\u8f91\u56fe\u8c31\u5931\u8d25,\u5931\u8d25\u4fe1\u606f:" + errorMsg;
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            log.info(logDto.toString());
        } else {
            log.error(logDto.toString());
        }
    }

    private void postActionExecutionProcessor(List<ActionExecutionDTO> actionExecutions, String tenantId, List<String> existsSysParamsWithoutRoot) throws Exception {
        for (ActionExecutionDTO e : actionExecutions) {
            List<ActionExecutionParamDTO> params;
            String token;
            Map headers;
            if (e instanceof ESPActionExecutionDTO) {
                String productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO)e).getServiceName(), tenantId);
                ((ESPActionExecutionDTO)e).setProductName(productName);
            } else if (e instanceof StartProcessActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartProcessActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartDataEventActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartDataEventActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartServiceComposerActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartServiceComposerActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            }
            if (!CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot) || !CollectionUtils.isNotEmpty(params = e.getParams())) continue;
            for (ActionExecutionParamDTO executionParamDTO : params) {
                String value = !(executionParamDTO instanceof MultiPathActionExecutionParamDTO) && executionParamDTO.getValue().startsWith("$.") ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
                if (!existsSysParamsWithoutRoot.contains(value)) continue;
                executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
            }
        }
    }
}

