/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service.impl;

import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.kg.monitorRule.TenantServiceConfig;
import com.digiwin.athena.kmservice.service.KmDBService;
import com.digiwin.athena.kmservice.service.KmTenantService;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class KmTenantServiceImpl
extends KmDBService
implements KmTenantService {
    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }

    @Override
    public TenantEntity getTenant(String tenantId) {
        return (TenantEntity)this.systemTemplate().findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class);
    }

    @Override
    public String getTenantVersion(String tenantId) {
        String version = "2.0";
        TenantEntity entity = this.getTenant(tenantId);
        if (null != entity) {
            version = entity.getVersion();
        }
        return version;
    }

    @Override
    public TenantServiceConfig getTenantServiceConfigByServiceName(String serviceName) {
        Query query = new Query();
        query.fields().include("productName");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"serviceName").is((Object)serviceName));
        return (TenantServiceConfig)this.systemTemplate().findOne(query, TenantServiceConfig.class, "serviceConfig");
    }

    @Override
    public TenantServiceConfig findTenantServiceConfig(String tenantId, String serviceName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("serviceName").is((Object)serviceName).and("status").is((Object)"1"));
        return (TenantServiceConfig)this.tenantTemplate().findOne(query, TenantServiceConfig.class);
    }

    @Override
    public void addTenantServiceConfig(String tenantId, String serviceName, String productName) {
        TenantServiceConfig tenantServiceConfig = new TenantServiceConfig();
        tenantServiceConfig.setTenantId(tenantId);
        tenantServiceConfig.setServiceName(serviceName);
        tenantServiceConfig.setProductName(productName);
        tenantServiceConfig.setStatus("1");
        this.tenantTemplate().save((Object)tenantServiceConfig);
    }

    @Override
    public void removeTenantServiceConfig(String tenantId, String serviceName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("serviceName").is((Object)serviceName));
        this.tenantTemplate().remove(query, TenantServiceConfig.class);
    }
}

