/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.client.MongoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;

public abstract class KmDBService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(KmDBService.class);
    private MongoTemplate mongoTemplateSys;
    private MongoTemplate mongoTemplateTenant;
    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier(value="mappingMongoConverterSystem")
    MongoConverter mappingMongoConverterSystem;

    public abstract MongoTemplate systemTemplate();

    public abstract MongoTemplate tenantTemplate();

    public void afterPropertiesSet() {
        SimpleMongoClientDatabaseFactory mongoDbFactorySys = new SimpleMongoClientDatabaseFactory(this.mongo, KnowledgeGraphDb.SYSTEM.getValue());
        this.mongoTemplateSys = new MongoTemplate((MongoDatabaseFactory)mongoDbFactorySys, this.mappingMongoConverterSystem);
        SimpleMongoClientDatabaseFactory mongoDbFactoryTenant = new SimpleMongoClientDatabaseFactory(this.mongo, KnowledgeGraphDb.TENANT.getValue());
        this.mongoTemplateTenant = new MongoTemplate((MongoDatabaseFactory)mongoDbFactoryTenant, this.mappingMongoConverterSystem);
    }

    public MongoTemplate getMongoTemplateSys() {
        return this.mongoTemplateSys;
    }

    public MongoTemplate getMongoTemplateTenant() {
        return this.mongoTemplateTenant;
    }

    public MongoClient getMongo() {
        return this.mongo;
    }

    public MongoConverter getMappingMongoConverterSystem() {
        return this.mappingMongoConverterSystem;
    }

    public void setMongoTemplateSys(MongoTemplate mongoTemplateSys) {
        this.mongoTemplateSys = mongoTemplateSys;
    }

    public void setMongoTemplateTenant(MongoTemplate mongoTemplateTenant) {
        this.mongoTemplateTenant = mongoTemplateTenant;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    public void setMappingMongoConverterSystem(MongoConverter mappingMongoConverterSystem) {
        this.mappingMongoConverterSystem = mappingMongoConverterSystem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KmDBService)) {
            return false;
        }
        KmDBService other = (KmDBService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongoTemplate this$mongoTemplateSys = this.getMongoTemplateSys();
        MongoTemplate other$mongoTemplateSys = other.getMongoTemplateSys();
        if (this$mongoTemplateSys == null ? other$mongoTemplateSys != null : !this$mongoTemplateSys.equals(other$mongoTemplateSys)) {
            return false;
        }
        MongoTemplate this$mongoTemplateTenant = this.getMongoTemplateTenant();
        MongoTemplate other$mongoTemplateTenant = other.getMongoTemplateTenant();
        if (this$mongoTemplateTenant == null ? other$mongoTemplateTenant != null : !this$mongoTemplateTenant.equals(other$mongoTemplateTenant)) {
            return false;
        }
        MongoClient this$mongo = this.getMongo();
        MongoClient other$mongo = other.getMongo();
        if (this$mongo == null ? other$mongo != null : !this$mongo.equals(other$mongo)) {
            return false;
        }
        MongoConverter this$mappingMongoConverterSystem = this.getMappingMongoConverterSystem();
        MongoConverter other$mappingMongoConverterSystem = other.getMappingMongoConverterSystem();
        return !(this$mappingMongoConverterSystem == null ? other$mappingMongoConverterSystem != null : !this$mappingMongoConverterSystem.equals(other$mappingMongoConverterSystem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KmDBService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongoTemplate $mongoTemplateSys = this.getMongoTemplateSys();
        result = result * 59 + ($mongoTemplateSys == null ? 43 : $mongoTemplateSys.hashCode());
        MongoTemplate $mongoTemplateTenant = this.getMongoTemplateTenant();
        result = result * 59 + ($mongoTemplateTenant == null ? 43 : $mongoTemplateTenant.hashCode());
        MongoClient $mongo = this.getMongo();
        result = result * 59 + ($mongo == null ? 43 : $mongo.hashCode());
        MongoConverter $mappingMongoConverterSystem = this.getMappingMongoConverterSystem();
        result = result * 59 + ($mappingMongoConverterSystem == null ? 43 : $mappingMongoConverterSystem.hashCode());
        return result;
    }

    public String toString() {
        return "KmDBService(mongoTemplateSys=" + this.getMongoTemplateSys() + ", mongoTemplateTenant=" + this.getMongoTemplateTenant() + ", mongo=" + this.getMongo() + ", mappingMongoConverterSystem=" + this.getMappingMongoConverterSystem() + ")";
    }
}

