/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class IAMUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(IAMUtils.class);
    @Value(value="${iamUrl:null}")
    private String iamUrl;
    @Value(value="${iamApToken:null}")
    private String iamApToken;
    @Value(value="${supportTenantV2:true}")
    private Boolean supportTenantV2;
    @Autowired
    @Qualifier(value="commonRestTemplate")
    RestTemplate restTemplate;
    private static ThreadLocal<String> localeHolder = new ThreadLocal();
    private static final String DEFAULT_LOCALE = "zh_CN";

    private String getDefaultLocale() {
        if (StringUtils.endsWithIgnoreCase((CharSequence)this.iamUrl, (CharSequence)".cn")) {
            return DEFAULT_LOCALE;
        }
        return "zh_TW";
    }

    public void setTenantLocalByToken(String token) {
        String apiMetadataUrl = this.iamUrl + "/api/iam/v2/tenant/metadata/language";
        String locale = null;
        try {
            URL restURL = new URL(apiMetadataUrl);
            HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("digi-middleware-auth-user", token);
            conn.setRequestProperty("digi-middleware-auth-app", this.iamApToken);
            conn.setDoOutput(true);
            JSONObject response = (JSONObject)JSON.parseObject((InputStream)conn.getInputStream(), JSONObject.class, (Feature[])new Feature[0]);
            locale = null == response.getString("data") || "".equals(response.getString("data")) ? this.getDefaultLocale() : response.getString("data");
        }
        catch (Exception e) {
            LOGGER.info("http get metadata language error:{}, set default locale:{}", (Object)e.getMessage(), (Object)this.getDefaultLocale());
            localeHolder.set(this.getDefaultLocale());
        }
        localeHolder.set(locale);
    }

    public String getTenantLocal() {
        return localeHolder.get();
    }

    public String getTenantLocale(String token) {
        String apiMetadataUrl = this.iamUrl + "/api/iam/v2/tenant/metadata/language";
        String locale = null;
        try {
            URL restURL = new URL(apiMetadataUrl);
            HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("digi-middleware-auth-user", token);
            conn.setRequestProperty("digi-middleware-auth-app", this.iamApToken);
            conn.setDoOutput(true);
            JSONObject response = (JSONObject)JSON.parseObject((InputStream)conn.getInputStream(), JSONObject.class, (Feature[])new Feature[0]);
            locale = StringUtils.isEmpty((CharSequence)response.getString("data")) ? this.getDefaultLocale() : response.getString("data");
            return locale;
        }
        catch (Exception e) {
            LOGGER.info("http get metadata language error:{}, set default locale:{}", (Object)e.getMessage(), (Object)this.getDefaultLocale());
            return this.getDefaultLocale();
        }
    }

    public Integer getTenantType(String token) throws IOException {
        String apiMetadataUrl = this.iamUrl + "/api/iam/v2/tenant/current";
        try {
            URL restURL = new URL(apiMetadataUrl);
            HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("digi-middleware-auth-user", token);
            conn.setRequestProperty("digi-middleware-auth-app", this.iamApToken);
            conn.setDoOutput(true);
            JSONObject response = (JSONObject)JSON.parseObject((InputStream)conn.getInputStream(), JSONObject.class, (Feature[])new Feature[0]);
            Integer type = response.getJSONObject("tenant").getInteger("enterpriseType");
            return type;
        }
        catch (Exception e) {
            LOGGER.error("http get tenant type error:{}, set default locale:{}", (Object)e.getMessage(), (Object)this.getDefaultLocale());
            throw e;
        }
    }

    public void removeLocale() {
        localeHolder.remove();
    }

    public JSONObject getTenantInfo(String token) throws DWBusinessException {
        String tenantInfoSimpleUrl = this.iamUrl + "/api/iam/v2/tenant/current/simple";
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(tenantInfoSimpleUrl, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)resEntity.getBody();
        if (body == null) {
            LOGGER.error("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5f02\u5e38\uff0c\u8fd4\u56debody\u4e3a\u7a7a");
            throw new DWBusinessException("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        if (MapUtils.getInteger((Map)body, (Object)"code") != 200) {
            throw new DWBusinessException(MapUtils.getString((Map)body, (Object)"message"));
        }
        return body.getJSONObject("data");
    }

    public String getTenantOperationUnitVersion(String token) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return "v1";
        }
        JSONObject tenantInfo = null;
        tenantInfo = this.getTenantInfo(token);
        return Optional.ofNullable(tenantInfo).map(t -> MapUtils.getString((Map)t, (Object)"version", (String)"v1")).orElse("v1");
    }

    public String getTenantOperationUnitVersion() throws DWBusinessException {
        if (DWServiceContext.getContext().getProfile() == null || MapUtils.isEmpty((Map)DWServiceContext.getContext().getProfile())) {
            DWServiceContext.getContext().setProfile(new HashMap());
        }
        if (!Boolean.TRUE.equals(this.supportTenantV2)) {
            DWServiceContext.getContext().getProfile().put("version", "v1");
            return "v1";
        }
        if (!DWServiceContext.getContext().getProfile().containsKey("version") || DWServiceContext.getContext().getProfile().get("version") == null) {
            Map headers = DWServiceContext.getContext().getRequestHeader();
            DWServiceContext.getContext().getProfile().put("version", this.getTenantOperationUnitVersion(MapUtils.getString((Map)headers, (Object)"token")));
        }
        String tenantOperationUnitVersion = MapUtils.getString((Map)DWServiceContext.getContext().getProfile(), (Object)"version");
        return Optional.ofNullable(tenantOperationUnitVersion).orElse("v1");
    }

    public boolean isTenantOperationUnitV2() {
        try {
            return "v2".equals(this.getTenantOperationUnitVersion());
        }
        catch (DWBusinessException e) {
            LOGGER.error("get tenant operation unit version error:", (Throwable)e);
            return false;
        }
    }

    public static boolean isTenantOperationUnitV2FromContext() {
        String version = Optional.ofNullable(DWServiceContext.getContext().getProfile()).map(p -> MapUtils.getString((Map)p, (Object)"version")).orElse("v1");
        return "v2".equals(version);
    }
}

