/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.povo.DapResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class KmHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(KmHttpUtil.class);
    private static Logger logger = LoggerFactory.getLogger(KmHttpUtil.class);
    private static final String utf8 = "utf8";
    public static final String dateformat1 = "yyyy-MM-dd HH:mm:ss";
    public static final String base64ImgPrefix = "data:image/png;base64,";
    public static final BigDecimal yuanUnit = new BigDecimal(100);
    private static final String base64Key = "VHVvMTIzNDU2WXU3ODlMaUJhaVRpYW4=";
    private static AntPathMatcher antMatcher = new AntPathMatcher();
    public static HttpClient httpclient = null;
    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner initHttpRoutePlanner;
    static HttpRoutePlanner httpRoutePlanner;

    @PostConstruct
    public void init() {
        httpRoutePlanner = this.initHttpRoutePlanner;
    }

    public static DapResponse request(String url, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        String json = KmHttpUtil.requestString(url, httpMethod, params);
        if (null != json) {
            result = (DapResponse)JSON.parseObject((String)json, DapResponse.class);
        }
        return result;
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params) {
        return KmHttpUtil.requestString(url, httpMethod, params, null);
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params, Map<String, String> headers) {
        String result = null;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        try {
            try {
                URL u = new URL(url);
                String kghost = u.getHost();
                headers.put("Host", kghost);
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
                headers.put("digi-middleware-auth-user", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if ("post".equalsIgnoreCase(httpMethod)) {
                log.info("Utils requestString beginning... \u5165\u53c2\uff1a{}\uff0c{}\uff0c{}", new Object[]{url, headers, params});
                result = KmHttpUtil.postJson(url, headers, params);
                log.info("Utils requestString ending... \u7ed3\u679c\uff1a{}", (Object)result);
            } else {
                result = KmHttpUtil.get(url, headers, params);
            }
        }
        catch (Exception e) {
            logger.error("request to {} failed," + e.getMessage(), (Object)url);
        }
        return result;
    }

    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                sslContext.init(null, new TrustManager[]{tm}, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            httpclient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext).setRoutePlanner(httpRoutePlanner).build();
        }
        return httpclient;
    }

    public static HttpClient buildHttpClient() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext).build();
        return client;
    }

    public static String getUrl(String url, Map<String, Object> params) {
        String result = url;
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    sb.append((String)k).append("=").append(URLEncoder.encode(v.toString(), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            result = url + sb.substring(0, sb.length() - 1).toString();
        }
        return result;
    }

    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList hs = new ArrayList();
            headers.forEach((k, v) -> hs.add(new BasicHeader(k, v)));
            return hs.toArray(new Header[0]);
        }
        return null;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpResponse response = KmHttpUtil.get0(url, KmHttpUtil.toHeader(headers), params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (logger.isInfoEnabled()) {
                logger.info("get result=" + result);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v.toString();
                    sb.append((String)k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);
        get.setHeaders(headers);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("get url=" + url + ",headers=" + JSON.toJSONString((Object)headers) + ",params=" + params);
        }
        try {
            response = KmHttpUtil.getHttpClient().execute((HttpUriRequest)get);
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) {
        Object result = null;
        try {
            result = JSON.parseObject((String)KmHttpUtil.get(url, headers, params), c);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(KmHttpUtil.toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody + " and header=" + headers);
        }
        try {
            response = KmHttpUtil.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static <T> T postJson(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) {
        Object result = null;
        try {
            result = JSON.parseObject((String)KmHttpUtil.postJson(url, headers, params), c);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)result;
    }

    public static HttpResponse postForm0(String url, Header[] headers, Map<String, Object> params) {
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(headers);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + params);
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String name : params.keySet()) {
            String value = String.valueOf(params.get(name));
            nvps.add(new BasicNameValuePair(name, value));
        }
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, utf8));
            response = KmHttpUtil.getHttpClient().execute((HttpUriRequest)httppost);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response =" + response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postForm(String url, Header[] headers, Map<String, Object> params) {
        String result = null;
        HttpResponse response = KmHttpUtil.postForm0(url, headers, params);
        if (null == response) {
            return null;
        }
        try {
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static Header[] requiredHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String routerKey = request.getHeader("routerKey");
        String token = request.getHeader("token");
        String locale = request.getHeader("locale");
        if (null == token) {
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
            locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        }
        if (null == token) {
            token = DWServiceContext.getContext().getToken();
        }
        if (null != routerKey) {
            headers.put("routerKey", routerKey);
        }
        if (null != token) {
            headers.put("token", token);
        }
        if (null != locale) {
            headers.put("locale", locale);
        }
        return KmHttpUtil.toHeader(headers);
    }

    public static void requiredHeaders(HttpHeaders headers) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (StringUtils.isEmpty((Object)token)) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (StringUtils.isEmpty((Object)token)) {
                token = DWServiceContext.getContext().getToken();
            }
            if (StringUtils.isEmpty((Object)securityToken)) {
                securityToken = (String)DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (!StringUtils.isEmpty((Object)routerKey)) {
                headers.set("routerKey", routerKey);
            }
            if (!StringUtils.isEmpty((Object)token)) {
                headers.set("token", token);
                headers.set("digi-middleware-auth-user", token);
            }
            if (!StringUtils.isEmpty((Object)locale)) {
                headers.set("locale", locale);
            }
            if (!StringUtils.isEmpty((Object)securityToken)) {
                headers.set("security-token", securityToken);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error,{}", (Object)e.toString());
        }
    }

    public static Long getTimeById(String id) {
        ObjectId objectId = new ObjectId(id);
        return objectId.getDate().getTime();
    }

    public static void main(String[] args) throws IllegalAccessException {
        HttpResponse response = KmHttpUtil.get0("http://localhost:8081/user/test/test01", null, null);
        String response2 = KmHttpUtil.get("http://localhost:8081/user/test/test01", null, null);
        System.out.println(response);
        System.out.println(response2);
    }
}

