/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.metadata;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.metadata.ActionHandler;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class KmActionClient
implements InitializingBean {
    private Map<String, ActionHandler> handler = new ConcurrentHashMap<String, ActionHandler>();

    public void afterPropertiesSet() throws Exception {
        Map handlerMap = SpringUtil.getBeansOfType(ActionHandler.class);
        for (Map.Entry entry : handlerMap.entrySet()) {
            this.handler.put(((ActionHandler)entry.getValue()).getActionLabel(), (ActionHandler)entry.getValue());
        }
    }

    public ActionDefinitionDTO doHandlerMetadata(List<String> actionLabels, Map<String, Object> actionMatched) throws Exception {
        Set<String> strings = this.handler.keySet();
        boolean exist = false;
        ActionDefinitionDTO result = null;
        for (String str : strings) {
            if (!actionLabels.contains(str)) continue;
            exist = true;
            result = this.handler.get(str).processMetadata(actionMatched);
            break;
        }
        if (exist) {
            return result;
        }
        throw new DWException("P.KG.500.0026", I18nUtils.getValue("knowledgegraph.actionPulled", new Object[0]) + actionMatched.get("actionId").toString());
    }

    public ActionExecutionDTO doHandlerExecution(List<String> actionLabels, Map<String, Object> actionMatched) throws Exception {
        Set<String> strings = this.handler.keySet();
        boolean exist = false;
        ActionExecutionDTO result = null;
        for (String str : strings) {
            if (!actionLabels.contains(str)) continue;
            exist = true;
            result = this.handler.get(str).processExecution(actionMatched);
            break;
        }
        if (exist) {
            return result;
        }
        throw new DWException("P.KG.500.0026", I18nUtils.getValue("knowledgegraph.actionPulled", new Object[0]) + actionMatched.get("actionId").toString());
    }
}

