/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.analysis;

import com.alibaba.fastjson.JSON;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalysisTool {
    public static Map<String, Object> jvmInfo() {
        HashMap<String, Object> detail;
        HashMap<String, Object> info = new HashMap<String, Object>();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        info.put("os.name", operatingSystemMXBean.getName());
        info.put("os.arch", operatingSystemMXBean.getArch());
        info.put("os.version", operatingSystemMXBean.getVersion());
        info.put("os.cores", operatingSystemMXBean.getAvailableProcessors());
        info.put("os.loadAverage", operatingSystemMXBean.getSystemLoadAverage());
        info.put("mem.heapMemoryUsage", memoryMXBean.getHeapMemoryUsage());
        info.put("mem.nonHeapMemoryUsage", memoryMXBean.getNonHeapMemoryUsage());
        HashMap poolmems = new HashMap();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            HashMap<String, Object> detail2 = new HashMap<String, Object>();
            detail2.put("type", (Object)memoryPoolMXBean.getType());
            detail2.put("usage", memoryPoolMXBean.getUsage());
            poolmems.put(memoryPoolMXBean.getName(), detail2);
        }
        info.put("mem.pools", poolmems);
        HashMap gcs = new HashMap();
        for (GarbageCollectorMXBean collectorMXBean : garbageCollectorMXBeans) {
            HashMap<String, Long> detail3 = new HashMap<String, Long>();
            detail3.put("count", collectorMXBean.getCollectionCount());
            detail3.put("time", collectorMXBean.getCollectionTime());
            gcs.put(collectorMXBean.getName(), detail3);
        }
        info.put("mem.gcInfo", gcs);
        info.put("thread.totalStartedThreadCount", threadMXBean.getTotalStartedThreadCount());
        info.put("thread.threadCount", threadMXBean.getThreadCount());
        info.put("thread.peakThreadCount", threadMXBean.getPeakThreadCount());
        info.put("thread.daemonThreadCount", threadMXBean.getDaemonThreadCount());
        long[] lArray = threadMXBean.findDeadlockedThreads();
        if (null != lArray) {
            ArrayList deadlocks = new ArrayList();
            for (Object id : (HashMap<String, Long>)lArray) {
                detail = new HashMap<String, Object>();
                detail.put("id", (long)id);
                ThreadInfo ti = threadMXBean.getThreadInfo((long)id);
                detail.put("name", ti.getThreadName());
                detail.put("trace", AnalysisTool.traceToString(ti.getStackTrace()));
                deadlocks.add(detail);
            }
            info.put("deadLocks", deadlocks);
        }
        ArrayList top10 = new ArrayList();
        ThreadInfo[] infos = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(infos, Comparator.comparing(in -> threadMXBean.getThreadCpuTime(in.getThreadId())));
        int count = infos.length;
        int ten = Math.min(10, count);
        int i = count;
        while (i > count - ten) {
            ThreadInfo ti = infos[--i];
            detail = new HashMap();
            detail.put("id", ti.getThreadId());
            detail.put("name", ti.getThreadName());
            detail.put("trace", AnalysisTool.traceToString(ti.getStackTrace()));
            detail.put("cpuTime", threadMXBean.getThreadCpuTime(ti.getThreadId()));
            top10.add(detail);
        }
        info.put("thread.top10", top10);
        return info;
    }

    public static List<Map<String, Object>> threadDump() {
        ThreadInfo[] infos;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadMXBean.dumpAllThreads(true, true)) {
            HashMap<String, Object> detail = new HashMap<String, Object>();
            detail.put("id", info.getThreadId());
            detail.put("name", info.getThreadName());
            detail.put("trace", AnalysisTool.traceToString(info.getStackTrace()));
            detail.put("cpuTime", threadMXBean.getThreadCpuTime(info.getThreadId()));
            list.add(detail);
        }
        return list;
    }

    static String traceToString(StackTraceElement[] traceElements) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement element : traceElements) {
            stringBuilder.append(element.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        Map<String, Object> obj = AnalysisTool.jvmInfo();
        System.out.println(JSON.toJSONString(obj, (boolean)true));
    }
}

