/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.neo4j;

import com.digiwin.athena.kmservice.neo4j.Cql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.util.Pair;

public class Neo4jManager {
    private Driver driver;
    private static final Integer RETRY_TIMES = 4;

    public Neo4jManager(Driver driver) {
        this.driver = driver;
    }

    public void ExecuteNoQuery(String statement) {
        try (Session session = this.driver.session();){
            session.run(statement);
        }
    }

    public void ExecuteNoQuery(String statement, Map<String, Object> params) {
        try (Session session = this.driver.session();){
            session.run(statement, params);
        }
    }

    public List<Map<String, Object>> ExecuteQuery(String statement) {
        ArrayList<Map<String, Object>> arrayList;
        block10: {
            Session session = this.driver.session();
            try {
                Result result = session.run(statement);
                ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
                while (result.hasNext()) {
                    Record record = result.next();
                    List fields = record.fields();
                    HashMap<String, Object> recordAsMap = new HashMap<String, Object>();
                    for (Pair field : fields) {
                        recordAsMap.put((String)field.key(), Neo4jManager.ParseNode(field.value()));
                    }
                    mapObjects.add(recordAsMap);
                }
                arrayList = mapObjects;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            session.close();
        }
        return arrayList;
    }

    public List<Map<String, Object>> ExecuteQuery(String statement, Map<String, Object> params) {
        ArrayList<Map<String, Object>> arrayList;
        block10: {
            Session session = this.driver.session();
            try {
                Result result = session.run(statement, params);
                ArrayList<Map<String, Object>> mapObjects = new ArrayList<Map<String, Object>>();
                while (result.hasNext()) {
                    Record record = result.next();
                    List fields = record.fields();
                    HashMap<String, Object> recordAsMap = new HashMap<String, Object>();
                    for (Pair field : fields) {
                        recordAsMap.put((String)field.key(), Neo4jManager.ParseNode(field.value()));
                    }
                    mapObjects.add(recordAsMap);
                }
                arrayList = mapObjects;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            session.close();
        }
        return arrayList;
    }

    public void ExecuteTransactionNoQuery(List<Cql> statementsAndParams) {
        for (int i = 0; i < RETRY_TIMES; ++i) {
            try (Session session = this.driver.session();){
                try (Transaction tx = session.beginTransaction();){
                    for (Cql cql : statementsAndParams) {
                        if (Objects.isNull(cql.getParams())) {
                            tx.run(cql.getCql());
                            continue;
                        }
                        tx.run(cql.getCql(), cql.getParams());
                    }
                    tx.commit();
                }
                return;
            }
            catch (TransientException e) {
                String message = e.getMessage();
                if (message.startsWith("LockClient")) {
                    if (i < RETRY_TIMES - 1) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(ex);
                        }
                    }
                    throw e;
                }
                throw e;
            }
        }
    }

    public void ExecuteOnCqlList(List<Cql> statementsAndParams) {
        try (Session session = this.driver.session();){
            statementsAndParams.forEach(cql -> session.run(cql.getCql(), cql.getParams()));
        }
    }

    private static Object ParseNode(Object value) {
        if (value instanceof NodeValue) {
            return ((Value)value).asNode();
        }
        if (value instanceof StringValue) {
            return ((Value)value).asString();
        }
        if (value instanceof BooleanValue) {
            return ((Value)value).asBoolean();
        }
        if (value instanceof IntegerValue) {
            long val = ((IntegerValue)value).asLong();
            if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                return val;
            }
            return ((Value)value).asInt();
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((Value)value).asFloat());
        }
        if (value instanceof ListValue) {
            ArrayList<Object> parsedValue = new ArrayList<Object>();
            List valueAsList = ((Value)value).asList();
            for (Object element : valueAsList) {
                parsedValue.add(Neo4jManager.ParseNode(element));
            }
            return parsedValue;
        }
        if (value instanceof MapValue) {
            return ((MapValue)value).asMap();
        }
        return value;
    }
}

