package com.digiwin.athena.kmservice.configuration.mongoConvert;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

import java.util.Arrays;
import java.util.List;

@ReadingConverter
@Slf4j
public class MechanismCapacityReadConverter implements Converter<Document, MechanismCapacity> {

    @Override
    public MechanismCapacity convert(Document obj) {
        try {
            JSONObject json = JSONObject.parseObject(JSONObject.toJSONString(obj));
            if (json.getJSONObject("action") != null && (json.getJSONObject("action").get("imWidget") != null)
                    && !(json.getJSONObject("action").get("imWidget") instanceof List)) {
                json.getJSONObject("action").put("imWidget", Arrays.asList(json.getJSONObject("action").getJSONObject("imWidget")));
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MechanismCapacity mechanismCapacity = objectMapper.readValue(objectMapper.writeValueAsString(json),
                    MechanismCapacity.class);
            //自定义序列化需要主要id转换 不存在id为null但还是判断下
            mechanismCapacity.setId(obj.get("_id") == null ? null : obj.get("_id").toString());
            return mechanismCapacity;
        } catch (Exception e) {
            log.error("MechanismCapacityReadConverter.convert error:{}",e);
        }
        return null;
    }
}
