/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ActionMetadata;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kmservice.service.KmDBCommonService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionMetadataManager {
    @Autowired
    private KmDBCommonService kmDBCommonService;
    @Autowired(required=false)
    private ActionRepository actionRepository;

    public EspActionMetadataDTO getActionMetadata(String actionId) throws Exception {
        ActionMetadata actionMetadataByActionId = this.kmDBCommonService.getActionMetadataByActionId(actionId);
        if (actionMetadataByActionId == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionNotFound2", new Object[0]) + actionId);
        }
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(actionMetadataByActionId.getServiceName());
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray((String)JSONObject.toJSONString((Object)actionMetadataByActionId.getRequestParameters()), ApiDataFieldMetadataDTO.class));
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)JSONObject.toJSONString((Object)actionMetadataByActionId.getResponseObject()), ApiDataFieldMetadataDTO.class));
        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);
        return metadataDTO;
    }

    public EspActionMetadataDTO getActionMetadata(String actionId, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(this.actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion), actionLabel -> actionLabel.getAction().entityBizCode(), actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        Action action = actionAndLabels.get(0).getAction();
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());
        metadataDTO.setName(action.getName());
        metadataDTO.setActionName(action.getActionName());
        metadataDTO.setActionName_tw(action.getActionName_tw());
        metadataDTO.setInvokeType(action.getInvokeType());
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray((String)action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class));
        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);
        metadataDTO.setSceneNodeType(action.getSceneNodeType());
        return metadataDTO;
    }

    public List<GetActionLocaleResponseDTO> getActionMetadatas(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(this.actionRepository.getActionAndLabels(actionIds, tenantId, tenantVersion), actionLabel -> actionLabel.getAction().entityBizCode(), actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionIds.toString(), tenantId));
        }
        return this.doPostActionMetadata(actionAndLabels);
    }

    public List<GetActionLocaleResponseDTO> getActionMetadatasByDataFlowCode(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(this.actionRepository.getActionAndLabelsByDataFlowCode(actionIds, tenantId, tenantVersion), actionLabel -> actionLabel.getAction().entityBizCode(), actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionIds.toString(), tenantId));
        }
        return this.doPostActionMetadata(actionAndLabels);
    }

    private List<GetActionLocaleResponseDTO> doPostActionMetadata(List<ActionLabel> actionAndLabels) {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        ArrayList<GetActionLocaleResponseDTO> metadataDTOs = new ArrayList<GetActionLocaleResponseDTO>();
        for (ActionLabel actionLabel : actionAndLabels) {
            Action action = actionLabel.getAction();
            EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
            metadataDTO.setActionId(action.getActionId());
            metadataDTO.setServiceName(action.getServiceName());
            metadataDTO.setIdempotency(action.getIdempotency());
            metadataDTO.setName(action.getName());
            metadataDTO.setActionName(action.getActionName());
            metadataDTO.setActionName_tw(action.getActionName_tw());
            metadataDTO.setDataFlowCode(action.getDataFlowCode());
            ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
            requestMetadataDTO.setParameters(JSON.parseArray((String)action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));
            ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
            responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class));
            metadataDTO.setRequest(requestMetadataDTO);
            metadataDTO.setResponse(responseMetadataDTO);
            metadataDTO.setSceneNodeType(action.getSceneNodeType());
            GetActionLocaleResponseDTO localeResponseDTO = (GetActionLocaleResponseDTO)JSON.parseObject((String)JSON.toJSONString((Object)metadataDTO), GetActionLocaleResponseDTO.class);
            MetadataTranslator.translateField(localeResponseDTO, (ActionMetadataDTO)metadataDTO, localeStr, null);
            metadataDTOs.add(localeResponseDTO);
        }
        return metadataDTOs;
    }
}

