package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;

import java.util.Map;
import java.util.Objects;

/**
 * @title: MicroTransformActionMetadataGenerator
 * @author: linc
 * @date 2023/11/22 14:53
 * @version: 1.0
 */
public class MicroTransformActionMetadataGenerator extends ActionMetadataGeneratorBase {

    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        ActionDefinitionDTO metadataDTO = new ActionDefinitionDTO();
        metadataDTO.setType(ActionTypeEnum.MICRO_TRANS);
        if (Objects.nonNull(actionQueryResult.get("microTrans"))) {
            metadataDTO.setMicroTrans(JSON.parseArray(actionQueryResult.get("microTrans").toString(), Object.class));
        }
        return metadataDTO;
    }
}
