package com.digiwin.athena.kmservice.action.metadata.model;

import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataField;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class DataEntityMetadataDTO extends ApiDataFieldMetadataDTO {
    private String entity_name;

    public static DataEntityMetadataDTO ConvertFromDataEntity(DataEntity entity) {
        DataEntityMetadataDTO metadataDTO = new DataEntityMetadataDTO();
        metadataDTO.setData_name(entity.getName());
        metadataDTO.setEntity_name(entity.getEntityName());
        metadataDTO.setData_type("object");
        metadataDTO.setIs_array(entity.getIsArray());
        List<ApiDataFieldMetadataDTO> fieldDTOs = new ArrayList<>();
        for (DataField field : entity.getField()) {
            ApiDataFieldMetadataDTO fieldDTO = new ApiDataFieldMetadataDTO();
            fieldDTO.setData_type(field.getDataType());
            fieldDTO.setIs_businesskey(field.isBusinessKey());
            fieldDTO.setData_name(field.getName());
            fieldDTOs.add(fieldDTO);
        }
        metadataDTO.setField(fieldDTOs);
        return metadataDTO;
    }
}
