package com.digiwin.athena.kmservice.service.impl;

import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.kg.monitorRule.TenantServiceConfig;
import com.digiwin.athena.kmservice.service.KmDBService;
import com.digiwin.athena.kmservice.service.KmTenantService;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;


@Service
public class KmTenantServiceImpl extends KmDBService implements KmTenantService {

    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }

    @Override
    public TenantEntity getTenant(String tenantId) {
        return this.systemTemplate().findOne(new Query(Criteria.where("tenantId").is(tenantId)), TenantEntity.class);
    }

    @Override
    public String getTenantVersion(String tenantId) {
        String version = "2.0";
        TenantEntity entity = this.getTenant(tenantId);
        if(null!=entity){
            version = entity.getVersion();
        }
        return version;
    }

    @Override
    public TenantServiceConfig getTenantServiceConfigByServiceName(String serviceName) {
        Query query = new Query();
        query.fields().include("productName");
        query.addCriteria(Criteria.where("serviceName").is(serviceName));
        return this.systemTemplate().findOne(query, TenantServiceConfig.class, "serviceConfig");
    }

    @Override
    public TenantServiceConfig findTenantServiceConfig(String tenantId, String serviceName) {
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId)
                .and("serviceName").is(serviceName).and("status").is("1"));
        return this.tenantTemplate().findOne(query, TenantServiceConfig.class);
    }

    @Override
    public void addTenantServiceConfig(String tenantId, String serviceName, String productName) {
        TenantServiceConfig tenantServiceConfig = new TenantServiceConfig();
        tenantServiceConfig.setTenantId(tenantId);
        tenantServiceConfig.setServiceName(serviceName);
        tenantServiceConfig.setProductName(productName);
        tenantServiceConfig.setStatus("1");
        this.tenantTemplate().save(tenantServiceConfig);
    }

    @Override
    public void removeTenantServiceConfig(String tenantId, String serviceName) {
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId)
                .and("serviceName").is(serviceName));
        this.tenantTemplate().remove(query, TenantServiceConfig.class);
    }
}
