package com.digiwin.athena.kmservice.support;



import com.digiwin.athena.domain.core.Activity;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-09-06 08:13
 **/

public class MergePolicyBuilder {

    private static Map<String, MergePolicy> policyMap = new ConcurrentHashMap<>();

    static {
        init();
    }

    public static MergePolicy of(){
        MergePolicy policy = new MergePolicy();
        addPublics(policy.getRegs());
        return policy;
    }
    public static MergePolicy of(String... regxs){
        MergePolicy policy = new MergePolicy();
        for(String reg:regxs){
            policy.getRegs().add(reg);
        }
        addPublics(policy.getRegs());
        return policy;
    }
    public static MergePolicy getPolicy(String key){
        MergePolicy policy = new MergePolicy();
        MergePolicy cached = policyMap.get(key);
        if(null!=cached){
            policy.setRegs(cached.getRegs());
        }else{
            addPublics(policy.getRegs());
        }
        return policy;
    }

    public static void init(){
        policyMap.put(Activity.class.getName(),of(".config.approve"));


    }

    public  static void addPublics(List<String> regs){
        regs.add(".*.lang");
    }


    public static void main(String[] args) {
//        String path = "config.approve";
//        System.out.println(match(path,"config.approve"));

//        MergePolicy policy = getPolicy("");
//        System.out.println(policy);
//        MergePolicy policy2 = getPolicy("");
//        System.out.println(policy==policy2);

//        String[] ss = new String[]{};
//
//        System.out.println(ss.getClass());

        System.out.println(".aa.bb.lang.aa".matches(".*.lang"));

    }

}
