/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.analysis;

import com.digiwin.athena.kmservice.analysis.UriAnalysisBean;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter
@Component
public class UriAnalysisFilter
extends OncePerRequestFilter {
    private Map<String, UriAnalysisBean> uriBeans = new HashMap<String, UriAnalysisBean>();
    private boolean uriAnalysisEnable = false;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long t1 = System.currentTimeMillis();
        boolean error = false;
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            if (this.uriAnalysisEnable) {
                long duration = System.currentTimeMillis() - t1;
                String uri = request.getRequestURI();
                UriAnalysisBean bean = this.uriBeans.get(uri);
                if (null == bean) {
                    bean = new UriAnalysisBean();
                    bean.setUri(uri);
                    bean.setStartTime(new Date());
                    this.uriBeans.put(uri, bean);
                }
                bean.getTotalCount().incrementAndGet();
                if (!error) {
                    bean.getSuccessCount().incrementAndGet();
                }
                bean.getTotalTime().addAndGet(duration);
                if (duration > bean.getMax()) {
                    bean.setMax(duration);
                }
                if (duration < bean.getMax()) {
                    bean.setMin(duration);
                }
            }
        }
    }

    public void startAnalysis() {
        this.uriAnalysisEnable = true;
        this.uriBeans.clear();
    }

    public void stopAnalysis() {
        this.uriAnalysisEnable = false;
        this.uriBeans.clear();
    }

    public Map<String, UriAnalysisBean> uriAnalysisBeanMap() {
        this.uriBeans.forEach((k, v) -> {
            if (v.getTotalCount().get() > 0) {
                v.setAvg(v.getTotalTime().get() / (long)v.getTotalCount().get());
                v.setSuccessRate(100 * v.getSuccessCount().get() / v.getTotalCount().get());
            }
        });
        return this.uriBeans;
    }
}

