/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.cache;

import com.digiwin.athena.kmservice.cache.Cache;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="cacheAspect2")
@Order(value=100)
public class CacheAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Around(value="@annotation(com.digiwin.athena.kmservice.cache.Cache)")
    public Object processCache(ProceedingJoinPoint jp) throws Throwable {
        Signature sig = jp.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        Method method = msig.getMethod();
        Cache annotation = method.getAnnotation(Cache.class);
        String key = annotation.key();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return jp.proceed();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object[] args = jp.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String parameterName = parameter.getName();
            Object parameterValue = args[i];
            param.put(parameterName, parameterValue);
        }
        Object keyObj = ServiceUtils.evalExpressionWithContext(key, param);
        Object result = this.redisTemplate.opsForValue().get(keyObj);
        if (null != result) {
            if (log.isInfoEnabled()) {
                log.info("get data from cache with key({})", keyObj);
            }
            return result;
        }
        result = jp.proceed();
        if (null != result) {
            this.redisTemplate.opsForValue().set(keyObj, result, annotation.ttlSecs(), TimeUnit.SECONDS);
        }
        return result;
    }
}

