/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.controller;

import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kmservice.analysis.AnalysisTool;
import com.digiwin.athena.kmservice.analysis.UriAnalysisBean;
import com.digiwin.athena.kmservice.analysis.UriAnalysisFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"kmtest"})
public class KmTestController {
    MongoTemplate mongoTemplate;
    @Autowired(required=false)
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;
    @Autowired
    UriAnalysisFilter uriAnalysisFilter;

    @GetMapping(value={"test01"})
    public String test01() {
        System.out.println(Thread.currentThread().getName() + " test01....");
        return "ok";
    }

    @GetMapping(value={"test02"})
    public String test02() {
        ThreadInfo[] infos;
        System.out.println(Thread.currentThread().getName() + " test02....");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadMXBean.dumpAllThreads(true, true)) {
            long cpuTime = threadMXBean.getThreadCpuTime(info.getThreadId());
            System.out.println(info.getThreadName() + " " + cpuTime);
        }
        return "ok";
    }

    @GetMapping(value={"test03"})
    public String test03() {
        System.out.println(Thread.currentThread().getName() + " test013....");
        Task a2 = new Task();
        a2.setCode("code2");
        a2.setName("name2");
        a2.setPattern("pattern2");
        HashMap<String, Object> config1 = new HashMap<String, Object>();
        HashMap<String, String> approve1 = new HashMap<String, String>();
        config1.put("param1", "value1");
        config1.put("param3", "value3");
        config1.put("approve", approve1);
        approve1.put("app1", "app0011");
        approve1.put("app3", "app0033");
        a2.setConfig(config1);
        a2.setLang(new HashMap());
        HashMap<String, String> nameLang1 = new HashMap<String, String>();
        nameLang1.put("zh_CN", "\u4f9b\u5e94\u5546\u56de\u590d1");
        nameLang1.put("zh_TW", "\u4f9b\u61c9\u5546\u56de\u89861");
        nameLang1.put("en_US", "supplier replay1");
        a2.getLang().put("name", nameLang1);
        HashMap<String, String> markLang = new HashMap<String, String>();
        markLang.put("zh_CN", "patternCN");
        markLang.put("zh_TW", "patternTW");
        markLang.put("en_US", "patternEN");
        a2.getLang().put("pattern", markLang);
        this.mongoTemplate.save((Object)a2);
        this.mongoTemplateTenant.save((Object)a2);
        return "ok";
    }

    @GetMapping(value={"startAnalysisUri"})
    public String startAnalysisUri() {
        this.uriAnalysisFilter.startAnalysis();
        return "ok";
    }

    @GetMapping(value={"stopAnalysisUri"})
    public String stopAnalysisUri() {
        this.uriAnalysisFilter.stopAnalysis();
        return "ok";
    }

    @GetMapping(value={"analysisInfo"})
    public Object analysisInfo() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        Map<String, UriAnalysisBean> uriInfo = this.uriAnalysisFilter.uriAnalysisBeanMap();
        Map<String, Object> jvmInfo = AnalysisTool.jvmInfo();
        result.put("requestInfo", uriInfo);
        result.put("jvmInfo", jvmInfo);
        return result;
    }

    @GetMapping(value={"stacktrace"})
    public Object stacktrace() {
        return AnalysisTool.threadDump();
    }
}

